/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.binding.ScalarTypeObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class Ipv4Address
implements ScalarTypeObject<String>,
Serializable {
    private static final long serialVersionUID = -7811024098214962896L;
    public static final List<String> PATTERN_CONSTANTS = ImmutableList.of((Object)"^(?:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?)$");
    private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
    private static final String regexes = "(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?";
    private final String _value;

    private static void check_valueLength(String value) {
    }

    @ConstructorParameters(value={"value"})
    public Ipv4Address(String _value) {
        if (_value != null) {
            Ipv4Address.check_valueLength(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        CodeHelpers.checkPattern((String)_value, (Pattern)patterns, (String)regexes);
        this._value = _value;
    }

    public Ipv4Address(Ipv4Address source) {
        this._value = source._value;
    }

    public static Ipv4Address getDefaultInstance(String defaultValue) {
        return new Ipv4Address(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Ipv4Address)) return false;
        Ipv4Address other = (Ipv4Address)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Ipv4Address.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

