/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.runtime.osgi.impl;

import com.google.common.base.Verify;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.yangtools.binding.runtime.osgi.OSGiBindingRuntimeContext;
import org.opendaylight.yangtools.binding.runtime.spi.ForwardingBindingRuntimeContext;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={BindingRuntimeContext.class}, immediate=true)
public final class GlobalBindingRuntimeContext
extends ForwardingBindingRuntimeContext {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalBindingRuntimeContext.class);
    private final Uint64 generation;
    private BindingRuntimeContext delegate;

    @Activate
    public GlobalBindingRuntimeContext(@Reference OSGiBindingRuntimeContext osgi) {
        this.generation = osgi.generation();
        this.delegate = (BindingRuntimeContext)osgi.service();
        LOG.info("Global BindingRuntimeContext generation {} activated", (Object)this.generation);
    }

    protected BindingRuntimeContext delegate() {
        return (BindingRuntimeContext)Verify.verifyNotNull((Object)this.delegate);
    }

    @Deactivate
    void deactivate() {
        this.delegate = null;
        LOG.info("Global BindingRuntimeContext generation {} deactivated", (Object)this.generation);
    }
}

