/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.runtime.osgi.impl;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.util.Dictionary;
import java.util.Map;
import org.opendaylight.yangtools.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.yangtools.binding.runtime.osgi.ModelGenerationAware;
import org.opendaylight.yangtools.binding.runtime.osgi.OSGiModuleInfoSnapshot;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(factory="org.opendaylight.mdsal.dom.schema.osgi.impl.OSGiEffectiveModelImpl", service={OSGiModuleInfoSnapshot.class})
public final class OSGiModuleInfoSnapshotImpl
implements OSGiModuleInfoSnapshot {
    static final String FACTORY_NAME = "org.opendaylight.mdsal.dom.schema.osgi.impl.OSGiEffectiveModelImpl";
    @VisibleForTesting
    static final String GENERATION = "org.opendaylight.mdsal.dom.schema.osgi.impl.Generation";
    @VisibleForTesting
    static final String DELEGATE = "org.opendaylight.mdsal.dom.schema.osgi.impl.ModuleInfoSnapshot";
    private static final Logger LOG = LoggerFactory.getLogger(OSGiModuleInfoSnapshotImpl.class);
    private final ModuleInfoSnapshot delegate;
    private final Uint64 generation;

    @Activate
    public OSGiModuleInfoSnapshotImpl(Map<String, ?> properties) {
        this.generation = (Uint64)Verify.verifyNotNull(properties.get(GENERATION));
        this.delegate = (ModuleInfoSnapshot)Verify.verifyNotNull(properties.get(DELEGATE));
        LOG.info("EffectiveModelContext generation {} activated", (Object)this.generation);
    }

    @Override
    public Uint64 generation() {
        return this.generation;
    }

    @Override
    public ModuleInfoSnapshot service() {
        return this.delegate;
    }

    @Deactivate
    void deactivate() {
        LOG.info("EffectiveModelContext generation {} deactivated", (Object)this.generation);
    }

    static Dictionary<String, ?> props(long generation, ModuleInfoSnapshot delegate) {
        return FrameworkUtil.asDictionary(Map.of("service.ranking", ModelGenerationAware.computeServiceRanking(generation), GENERATION, Uint64.fromLongBits((long)generation), DELEGATE, delegate));
    }
}

