/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.runtime.osgi.impl;

import com.google.common.io.Resources;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.binding.meta.YangFeatureProvider;
import org.opendaylight.yangtools.binding.meta.YangModelBindingProvider;
import org.opendaylight.yangtools.binding.meta.YangModuleInfo;
import org.opendaylight.yangtools.binding.runtime.osgi.impl.YangModuleInfoRegistry;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YangModuleInfoScanner
extends BundleTracker<Registration> {
    private static final Logger LOG = LoggerFactory.getLogger(YangModuleInfoScanner.class);
    private static final Registration NOOP_REGISTRATION = () -> {};
    private static final String MODULE_INFO_PROVIDER_PATH_PREFIX = "META-INF/services/";
    private final YangModuleInfoRegistry moduleInfoRegistry;

    YangModuleInfoScanner(BundleContext context, YangModuleInfoRegistry moduleInfoRegistry) {
        super(context, 60, null);
        this.moduleInfoRegistry = Objects.requireNonNull(moduleInfoRegistry);
    }

    public Registration addingBundle(Bundle bundle, BundleEvent event) {
        if (bundle.getBundleId() == 0L) {
            LOG.debug("Not scanning system bundle {}", (Object)bundle);
            return NOOP_REGISTRATION;
        }
        List<YangModuleInfo> moduleInfos = YangModuleInfoScanner.loadBundleServices(bundle, YangModelBindingProvider.class).stream().map(YangModelBindingProvider::getModuleInfo).collect(Collectors.toUnmodifiableList());
        List<YangFeatureProvider<?>> featureProviders = YangModuleInfoScanner.loadBundleServices(bundle, YangFeatureProvider.class);
        if (moduleInfos.isEmpty() && featureProviders.isEmpty()) {
            LOG.debug("Bundle {} does not have any interesting service", (Object)bundle);
            return null;
        }
        Registration reg = this.moduleInfoRegistry.registerBundle(moduleInfos, featureProviders);
        this.moduleInfoRegistry.scannerUpdate();
        return reg;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Registration object) {
        if (bundle.getBundleId() == 0L) {
            LOG.debug("Framework bundle {} got event {}", (Object)bundle, (Object)event.getType());
            if ((event.getType() & 0x100) != 0) {
                LOG.info("OSGi framework is being stopped, halting bundle scanning");
                this.moduleInfoRegistry.scannerShutdown();
            }
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Registration object) {
        object.close();
        this.moduleInfoRegistry.scannerUpdate();
    }

    private static <T> List<T> loadBundleServices(Bundle bundle, Class<T> serviceClass) {
        List lines;
        String serviceName = serviceClass.getName();
        String serviceEntry = MODULE_INFO_PROVIDER_PATH_PREFIX + serviceName;
        URL resource = bundle.getEntry(serviceEntry);
        if (resource == null) {
            LOG.debug("Bundle {} does not have an entry for {}", (Object)bundle, (Object)serviceEntry);
            return List.of();
        }
        LOG.debug("Got addingBundle({}) with {} resource {}", new Object[]{bundle, serviceName, resource});
        try {
            lines = Resources.readLines((URL)resource, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Error while reading {} from bundle {}", new Object[]{resource, bundle, e});
            return List.of();
        }
        if (lines.isEmpty()) {
            LOG.debug("Bundle {} has empty services for {}", (Object)bundle, (Object)serviceEntry);
            return List.of();
        }
        ArrayList<T> services = new ArrayList<T>(lines.size());
        for (String implName : lines) {
            T service;
            LOG.trace("Retrieve ModuleInfo({}, {})", (Object)implName, (Object)bundle);
            try {
                service = YangModuleInfoScanner.loadImpl(serviceClass, bundle, implName);
            }
            catch (ScanningException e) {
                LOG.warn("Failed to acquire {} from bundle {}, ignoring it", new Object[]{implName, bundle, e});
                continue;
            }
            services.add(service);
        }
        return services;
    }

    private static <T> @NonNull T loadImpl(Class<T> type, Bundle bundle, String className) throws ScanningException {
        Constructor<T> ctor;
        Class<T> providerClass;
        Class loadedClass;
        try {
            loadedClass = bundle.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ScanningException(e, "Failed to load class %s", className);
        }
        try {
            providerClass = loadedClass.asSubclass(type);
        }
        catch (ClassCastException e) {
            throw new ScanningException(e, "Failed to validate %s", loadedClass);
        }
        try {
            ctor = providerClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ScanningException(e, "%s does not have a no-argument constructor", providerClass);
        }
        catch (SecurityException e) {
            throw new ScanningException(e, "Failed to reflect on %s", providerClass);
        }
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new ScanningException(e, "Failed to instantiate %s", providerClass);
        }
    }

    @NonNullByDefault
    private static final class ScanningException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ScanningException(Exception cause, String format, Object ... args) {
            super(String.format(format, args), cause);
        }
    }
}

