/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.util.OIOMv1;
import org.opendaylight.yangtools.util.UIOMv1;

abstract sealed class IOMv1<T extends ImmutableOffsetMap<?, ?>>
implements Externalizable
permits OIOMv1, UIOMv1 {
    private static final long serialVersionUID = 1L;
    private ImmutableOffsetMap<?, ?> map;

    IOMv1() {
    }

    IOMv1(@NonNull T map) {
        this.map = (ImmutableOffsetMap)Objects.requireNonNull(map);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        ImmutableOffsetMap local = (ImmutableOffsetMap)Verify.verifyNotNull(this.map);
        out.writeInt(local.size());
        for (Map.Entry e : local.entrySet()) {
            out.writeObject(e.getKey());
            out.writeObject(e.getValue());
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        ImmutableList.Builder keysBuilder = ImmutableList.builderWithExpectedSize((int)size);
        Object[] values = new Object[size];
        for (int i = 0; i < size; ++i) {
            keysBuilder.add(in.readObject());
            values[i] = in.readObject();
        }
        this.map = (ImmutableOffsetMap)Verify.verifyNotNull(this.createInstance((ImmutableList<Object>)keysBuilder.build(), values));
    }

    abstract @NonNull T createInstance(@NonNull ImmutableList<Object> var1, @NonNull Object[] var2);

    final Object readResolve() {
        return Verify.verifyNotNull(this.map);
    }
}

