/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class LazyCollections {
    private LazyCollections() {
    }

    public static <E> List<E> lazyAdd(List<E> list, E obj) {
        List<E> ret;
        switch (list.size()) {
            case 0: {
                return Collections.singletonList(obj);
            }
            case 1: {
                ret = new ArrayList(2);
                ret.addAll(list);
                break;
            }
            default: {
                ret = list;
            }
        }
        ret.add(obj);
        return ret;
    }

    public static <E> Set<E> lazyAdd(Set<E> set, E obj) {
        Set<E> ret;
        switch (set.size()) {
            case 0: {
                return Collections.singleton(obj);
            }
            case 1: {
                ret = new HashSet(4);
                ret.addAll(set);
                break;
            }
            default: {
                ret = set;
            }
        }
        ret.add(obj);
        return ret;
    }
}

