/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.runtime.SwitchBootstraps;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.util.ModifiableMapPhase;
import org.opendaylight.yangtools.util.OffsetMapCache;
import org.opendaylight.yangtools.util.SharedSingletonMap;
import org.opendaylight.yangtools.util.UnmodifiableMapPhase;

public abstract class MutableOffsetMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
ModifiableMapPhase<K, V> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Object REMOVED = new Object();
    private final ImmutableMap<K, Integer> offsets;
    private HashMap<K, V> newKeys;
    private Object[] objects;
    private int removed = 0;
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"})
    private volatile transient int modCount;
    private boolean needClone = true;

    MutableOffsetMap(ImmutableMap<K, Integer> offsets, Object[] objects) {
        this.offsets = Objects.requireNonNull(offsets);
        this.objects = Objects.requireNonNull(objects);
    }

    MutableOffsetMap() {
        this(ImmutableMap.of(), EMPTY_ARRAY);
    }

    MutableOffsetMap(ImmutableMap<K, Integer> offsets, Map<K, V> source) {
        this(offsets, new Object[offsets.size()]);
        for (Map.Entry<K, V> entry : source.entrySet()) {
            this.objects[((Integer)Verify.verifyNotNull((Object)((Integer)offsets.get(entry.getKey())))).intValue()] = Objects.requireNonNull(entry.getValue());
        }
        this.needClone = false;
    }

    public static <K, V> @NonNull MutableOffsetMap<K, V> orderedCopyOf(Map<K, V> map) {
        Map<K, V> map2 = map;
        Objects.requireNonNull(map2);
        Map<K, V> map3 = map2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Ordered.class, ImmutableOffsetMap.class}, map3, n)) {
            case 0 -> {
                Ordered ordered = (Ordered)map3;
                yield ordered.clone();
            }
            case 1 -> {
                ImmutableOffsetMap iom = (ImmutableOffsetMap)map3;
                yield new Ordered(iom.offsets(), iom.objects());
            }
            default -> new Ordered<K, V>(map);
        };
    }

    public static <K, V> @NonNull MutableOffsetMap<K, V> unorderedCopyOf(Map<K, V> map) {
        Map<K, V> map2 = map;
        Objects.requireNonNull(map2);
        Map<K, V> map3 = map2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Unordered.class, ImmutableOffsetMap.class}, map3, n)) {
            case 0 -> {
                Unordered unordered = (Unordered)map3;
                yield unordered.clone();
            }
            case 1 -> {
                ImmutableOffsetMap iom = (ImmutableOffsetMap)map3;
                yield new Unordered(iom.offsets(), iom.objects());
            }
            default -> new Unordered<K, V>(map);
        };
    }

    public static <K, V> @NonNull MutableOffsetMap<K, V> ordered() {
        return new Ordered();
    }

    public static <K, V> @NonNull MutableOffsetMap<K, V> unordered() {
        return new Unordered();
    }

    abstract Object removedObject();

    abstract UnmodifiableMapPhase<K, V> modifiedMap(List<K> var1, V[] var2);

    abstract UnmodifiableMapPhase<K, V> unmodifiedMap(ImmutableMap<K, Integer> var1, V[] var2);

    abstract SharedSingletonMap<K, V> singletonMap();

    @Override
    public final int size() {
        return this.offsets.size() - this.removed + (this.newKeys == null ? 0 : this.newKeys.size());
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean containsKey(Object key) {
        Object obj;
        Integer offset = (Integer)this.offsets.get(key);
        if (offset != null && !REMOVED.equals(obj = this.objects[offset])) {
            return obj != null;
        }
        return this.newKeys != null && this.newKeys.containsKey(key);
    }

    @Override
    public final V get(Object key) {
        Object obj;
        Integer offset = (Integer)this.offsets.get(key);
        if (offset != null && !REMOVED.equals(obj = this.objects[offset])) {
            Object ret = obj;
            return (V)ret;
        }
        return this.newKeys == null ? null : (V)this.newKeys.get(key);
    }

    private void cloneArray() {
        if (this.needClone) {
            this.needClone = false;
            if (this.objects.length != 0) {
                this.objects = (Object[])this.objects.clone();
            }
        }
    }

    @Override
    public final V put(K key, V value) {
        V ret;
        Object obj;
        Objects.requireNonNull(value);
        Integer offset = (Integer)this.offsets.get(Objects.requireNonNull(key));
        if (offset != null && !REMOVED.equals(obj = this.objects[offset])) {
            Object ret2 = obj;
            this.cloneArray();
            this.objects[offset.intValue()] = value;
            if (ret2 == null) {
                ++this.modCount;
                --this.removed;
            }
            return (V)ret2;
        }
        if (this.newKeys == null) {
            this.newKeys = this.createNewKeys();
        }
        if ((ret = this.newKeys.put(key, value)) == null) {
            ++this.modCount;
        }
        return ret;
    }

    @Override
    public final V remove(Object key) {
        Object obj;
        Integer offset = (Integer)this.offsets.get(key);
        if (offset != null && !REMOVED.equals(obj = this.objects[offset])) {
            this.cloneArray();
            Object ret = obj;
            this.objects[offset.intValue()] = this.removedObject();
            if (ret != null) {
                ++this.modCount;
                ++this.removed;
            }
            return (V)ret;
        }
        if (this.newKeys == null) {
            return null;
        }
        V ret = this.newKeys.remove(key);
        if (ret != null) {
            ++this.modCount;
        }
        return ret;
    }

    @Override
    public final void clear() {
        if (this.size() != 0) {
            if (this.newKeys != null) {
                this.newKeys.clear();
            }
            this.cloneArray();
            Arrays.fill(this.objects, this.removedObject());
            this.removed = this.objects.length;
            ++this.modCount;
        }
    }

    @Override
    public final @NonNull Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public @NonNull Map<K, V> toUnmodifiableMap() {
        if (this.removed == 0 && this.noNewKeys()) {
            this.needClone = true;
            Object[] values = this.objects;
            return this.unmodifiedMap(this.offsets, values);
        }
        int s = this.size();
        if (s == 0) {
            return ImmutableMap.of();
        }
        if (s == 1) {
            return this.singletonMap();
        }
        ArrayList<K> keyset = new ArrayList<K>(s);
        if (this.removed != 0) {
            if (this.removed != this.offsets.size()) {
                for (Map.Entry entry : this.offsets.entrySet()) {
                    Object obj = this.objects[(Integer)entry.getValue()];
                    if (obj == null || REMOVED.equals(obj)) continue;
                    keyset.add(entry.getKey());
                }
            }
        } else {
            keyset.addAll((Collection<K>)this.offsets.keySet());
        }
        if (this.newKeys != null) {
            keyset.addAll(this.newKeys.keySet());
        }
        Object[] values = new Object[keyset.size()];
        int offset = 0;
        if (this.removed != 0) {
            if (this.removed != this.offsets.size()) {
                for (Map.Entry entry : this.offsets.entrySet()) {
                    Object obj = this.objects[(Integer)entry.getValue()];
                    if (obj == null || REMOVED.equals(obj)) continue;
                    Object v = obj;
                    values[offset++] = v;
                }
            }
        } else {
            System.arraycopy(this.objects, 0, values, 0, this.offsets.size());
            offset = this.offsets.size();
        }
        if (this.newKeys != null) {
            for (Object v : this.newKeys.values()) {
                values[offset++] = v;
            }
        }
        return this.modifiedMap(keyset, values);
    }

    @Override
    public @NonNull MutableOffsetMap<K, V> clone() {
        MutableOffsetMap ret;
        try {
            ret = (MutableOffsetMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone is expected to work", e);
        }
        ret.newKeys = this.newKeys == null ? null : (HashMap)this.newKeys.clone();
        ret.needClone = true;
        return ret;
    }

    @Override
    public final int hashCode() {
        int result = 0;
        for (Map.Entry entry : this.offsets.entrySet()) {
            Object v = this.objects[(Integer)entry.getValue()];
            if (v == null) continue;
            result += entry.getKey().hashCode() ^ v.hashCode();
        }
        return this.newKeys != null ? result + this.newKeys.hashCode() : result;
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (other instanceof ImmutableOffsetMap) {
            ImmutableOffsetMap om = (ImmutableOffsetMap)other;
            if (this.noNewKeys() && this.offsets.equals(om.offsets())) {
                return Arrays.deepEquals(this.objects, om.objects());
            }
        } else if (other instanceof MutableOffsetMap) {
            MutableOffsetMap om = (MutableOffsetMap)other;
            if (this.offsets.equals(om.offsets)) {
                return Arrays.deepEquals(this.objects, om.objects) && this.equalNewKeys(om);
            }
        }
        return this.mapEquals((Map)obj);
    }

    private boolean equalNewKeys(MutableOffsetMap<?, ?> other) {
        return this.noNewKeys() ? other.noNewKeys() : this.newKeys.equals(other.newKeys());
    }

    private boolean mapEquals(Map<?, ?> other) {
        if (this.size() != other.size() || !this.keySet().equals(other.keySet())) {
            return false;
        }
        try {
            if (this.newKeys != null) {
                for (Map.Entry entry : this.newKeys.entrySet()) {
                    if (entry.getValue().equals(other.get(entry.getKey()))) continue;
                    return false;
                }
            }
            for (Map.Entry entry : this.offsets.entrySet()) {
                Object val = this.objects[(Integer)entry.getValue()];
                if (val == null || REMOVED.equals(val) || val.equals(other.get(entry.getKey()))) continue;
                return false;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    @Override
    public final @NonNull Set<K> keySet() {
        return new KeySet();
    }

    @VisibleForTesting
    final boolean needClone() {
        return this.needClone;
    }

    @VisibleForTesting
    final Object array() {
        return this.objects;
    }

    @VisibleForTesting
    final Object newKeys() {
        return this.newKeys != null ? this.newKeys : ImmutableMap.of();
    }

    abstract HashMap<K, V> createNewKeys();

    private boolean noNewKeys() {
        return this.newKeys == null || this.newKeys.isEmpty();
    }

    static final class Ordered<K, V>
    extends MutableOffsetMap<K, V> {
        Ordered() {
        }

        Ordered(Map<K, V> source) {
            super(OffsetMapCache.orderedOffsets(source.keySet()), source);
        }

        Ordered(ImmutableMap<K, Integer> offsets, V[] objects) {
            super(offsets, objects);
        }

        @Override
        Object removedObject() {
            return REMOVED;
        }

        @Override
        UnmodifiableMapPhase<K, V> modifiedMap(List<K> keys, V[] values) {
            return new ImmutableOffsetMap.Ordered<K, V>(OffsetMapCache.orderedOffsets(keys), values);
        }

        @Override
        UnmodifiableMapPhase<K, V> unmodifiedMap(ImmutableMap<K, Integer> offsetMap, V[] values) {
            return new ImmutableOffsetMap.Ordered<K, V>(offsetMap, values);
        }

        @Override
        SharedSingletonMap<K, V> singletonMap() {
            return SharedSingletonMap.orderedCopyOf(this);
        }

        @Override
        HashMap<K, V> createNewKeys() {
            return new LinkedHashMap();
        }
    }

    static final class Unordered<K, V>
    extends MutableOffsetMap<K, V> {
        Unordered() {
        }

        Unordered(Map<K, V> source) {
            super(OffsetMapCache.unorderedOffsets(source.keySet()), source);
        }

        Unordered(ImmutableMap<K, Integer> offsets, V[] objects) {
            super(offsets, objects);
        }

        @Override
        Object removedObject() {
            return null;
        }

        @Override
        UnmodifiableMapPhase<K, V> modifiedMap(List<K> keys, V[] values) {
            ImmutableMap<K, Integer> offsets = OffsetMapCache.unorderedOffsets(keys);
            return new ImmutableOffsetMap.Unordered<K, V>(offsets, OffsetMapCache.adjustedArray(offsets, keys, values));
        }

        @Override
        UnmodifiableMapPhase<K, V> unmodifiedMap(ImmutableMap<K, Integer> offsetMap, V[] values) {
            return new ImmutableOffsetMap.Unordered<K, V>(offsetMap, values);
        }

        @Override
        SharedSingletonMap<K, V> singletonMap() {
            return SharedSingletonMap.unorderedCopyOf(this);
        }

        @Override
        HashMap<K, V> createNewKeys() {
            return new HashMap();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public @NonNull Iterator<Map.Entry<K, V>> iterator() {
            return new AbstractSetIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    Object key = this.nextKey();
                    return new AbstractMap.SimpleEntry(key, MutableOffsetMap.this.get(key));
                }
            };
        }

        @Override
        public int size() {
            return MutableOffsetMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getValue() == null) {
                return false;
            }
            return e.getValue().equals(MutableOffsetMap.this.get(e.getKey()));
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            Object p;
            Object v = Objects.requireNonNull(e.getValue());
            return !v.equals(p = MutableOffsetMap.this.put(e.getKey(), v));
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getValue() == null) {
                return false;
            }
            Object v = MutableOffsetMap.this.get(e.getKey());
            if (e.getValue().equals(v)) {
                MutableOffsetMap.this.remove(e.getKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            MutableOffsetMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public @NonNull Iterator<K> iterator() {
            return new AbstractSetIterator<K>(this){

                @Override
                public K next() {
                    return this.nextKey();
                }
            };
        }

        @Override
        public int size() {
            return MutableOffsetMap.this.size();
        }
    }

    private abstract class AbstractSetIterator<E>
    implements Iterator<E> {
        private final Iterator<Map.Entry<K, Integer>> oldIterator;
        private final Iterator<K> newIterator;
        private int expectedModCount;
        private @Nullable K currentKey;
        private @Nullable K nextKey;

        AbstractSetIterator() {
            this.oldIterator = MutableOffsetMap.this.offsets.entrySet().iterator();
            this.newIterator = MutableOffsetMap.this.newKeys == null ? Collections.emptyIterator() : MutableOffsetMap.this.newKeys.keySet().iterator();
            this.expectedModCount = MutableOffsetMap.this.modCount;
            this.currentKey = null;
            this.updateNextKey();
        }

        private void updateNextKey() {
            while (this.oldIterator.hasNext()) {
                Map.Entry entry = this.oldIterator.next();
                Object obj = MutableOffsetMap.this.objects[entry.getValue()];
                if (obj == null || REMOVED.equals(obj)) continue;
                this.nextKey = entry.getKey();
                return;
            }
            this.nextKey = this.newIterator.hasNext() ? this.newIterator.next() : null;
        }

        private void checkModCount() {
            if (MutableOffsetMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public final boolean hasNext() {
            this.checkModCount();
            return this.nextKey != null;
        }

        @Override
        public final void remove() {
            this.checkModCount();
            Preconditions.checkState((this.currentKey != null ? 1 : 0) != 0);
            Integer offset = (Integer)MutableOffsetMap.this.offsets.get(this.currentKey);
            if (offset != null) {
                MutableOffsetMap.this.cloneArray();
                MutableOffsetMap.this.objects[offset.intValue()] = MutableOffsetMap.this.removedObject();
                ++MutableOffsetMap.this.removed;
            } else {
                this.newIterator.remove();
            }
            this.expectedModCount = ++MutableOffsetMap.this.modCount;
            this.currentKey = null;
        }

        protected final K nextKey() {
            if (this.nextKey == null) {
                throw new NoSuchElementException();
            }
            this.checkModCount();
            this.currentKey = this.nextKey;
            this.updateNextKey();
            return this.currentKey;
        }
    }
}

