/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.collect.ForwardingMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.util.ReadOnlyTrieMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.pantheon.triemap.MutableTrieMap;
import tech.pantheon.triemap.TrieMap;

final class ReadWriteTrieMap<K, V>
extends ForwardingMap<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(ReadWriteTrieMap.class);
    private final MutableTrieMap<K, V> delegate;
    private int size;

    ReadWriteTrieMap() {
        this.delegate = TrieMap.create();
        this.size = 0;
    }

    ReadWriteTrieMap(MutableTrieMap<K, V> delegate, int size) {
        this.delegate = Objects.requireNonNull(delegate);
        this.size = size;
    }

    protected Map<K, V> delegate() {
        return this.delegate;
    }

    Map<K, V> toReadOnly() {
        ReadOnlyTrieMap<K, V> ret = new ReadOnlyTrieMap<K, V>(this.delegate, this.size);
        LOG.trace("Converted read-write TrieMap {} to read-only {}", (Object)this, ret);
        return ret;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public V put(K key, V value) {
        Object ret = this.delegate.put(key, value);
        if (ret == null) {
            ++this.size;
        }
        return (V)ret;
    }

    public V remove(Object key) {
        Object ret = this.delegate.remove(key);
        if (ret != null) {
            --this.size;
        }
        return (V)ret;
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void clear() {
        this.delegate.clear();
        this.size = 0;
    }

    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.delegate.values());
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.delegate.entrySet());
    }
}

