/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.ImmutableMapTemplate;
import org.opendaylight.yangtools.util.SharedSingletonMap;
import org.opendaylight.yangtools.util.SingletonSet;

public abstract sealed class SharedSingletonMapTemplate<K>
extends ImmutableMapTemplate<K> {
    private final @NonNull SingletonSet<K> keySet;

    private SharedSingletonMapTemplate(K key) {
        this.keySet = SharedSingletonMap.cachedSet(key);
    }

    public static <K> @NonNull SharedSingletonMapTemplate<K> ordered(K key) {
        return new Ordered<K>(key);
    }

    public static <K> @NonNull SharedSingletonMapTemplate<K> unordered(K key) {
        return new Unordered<K>(key);
    }

    @Override
    public final SingletonSet<K> keySet() {
        return this.keySet;
    }

    @Override
    public final <T, V> @NonNull SharedSingletonMap<K, V> instantiateTransformed(Map<K, T> fromMap, BiFunction<K, T, V> valueTransformer) {
        K actual;
        Iterator<Map.Entry<K, T>> it = fromMap.entrySet().iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Input is empty while expecting 1 item");
        }
        Map.Entry<K, T> entry = it.next();
        K expected = this.keySet.getFirst();
        if (!expected.equals(actual = entry.getKey())) {
            throw new IllegalArgumentException("Unexpected key " + String.valueOf(actual) + ", expecting " + String.valueOf(expected));
        }
        V value = this.transformValue(actual, entry.getValue(), valueTransformer);
        if (it.hasNext()) {
            throw new IllegalArgumentException("Input has more than one item");
        }
        return this.instantiateWithValue(value);
    }

    @Override
    @SafeVarargs
    public final <V> @NonNull SharedSingletonMap<K, V> instantiateWithValues(V ... values) {
        SharedSingletonMapTemplate.checkSize(1, values.length);
        return this.instantiateWithValue(values[0]);
    }

    public abstract <V> @NonNull SharedSingletonMap<K, V> instantiateWithValue(V var1);

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("keySet", this.keySet).toString();
    }

    private static final class Ordered<K>
    extends SharedSingletonMapTemplate<K> {
        Ordered(K key) {
            super(key);
        }

        @Override
        public <V> @NonNull SharedSingletonMap<K, V> instantiateWithValue(V value) {
            return new SharedSingletonMap.Ordered(this.keySet(), value);
        }
    }

    private static final class Unordered<K>
    extends SharedSingletonMapTemplate<K> {
        Unordered(K key) {
            super(key);
        }

        @Override
        public <V> @NonNull SharedSingletonMap<K, V> instantiateWithValue(V value) {
            return new SharedSingletonMap.Unordered(this.keySet(), value);
        }
    }
}

