/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.spi.store.AbstractDOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.concurrent.EqualityQueuedNotificationManager;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InMemoryDOMStoreTreeChangePublisher
extends AbstractDOMStoreTreeChangePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMStoreTreeChangePublisher.class);
    private final EqualityQueuedNotificationManager<AbstractDOMStoreTreeChangePublisher.Reg, DataTreeCandidate> notificationManager;

    InMemoryDOMStoreTreeChangePublisher(String dsName, Executor listenerExecutor, int maxQueueSize) {
        this.notificationManager = new EqualityQueuedNotificationManager("DataTreeChangeListenerQueueMgr + dsName", listenerExecutor, maxQueueSize, (listener, notifications) -> {
            if (listener.notClosed()) {
                listener.listener().onDataTreeChanged((List)notifications);
            }
        });
    }

    private InMemoryDOMStoreTreeChangePublisher(EqualityQueuedNotificationManager<AbstractDOMStoreTreeChangePublisher.Reg, DataTreeCandidate> notificationManager) {
        this.notificationManager = notificationManager;
    }

    EqualityQueuedNotificationManager<?, ?> getNotificationManager() {
        return this.notificationManager;
    }

    protected void notifyListener(AbstractDOMStoreTreeChangePublisher.Reg registration, List<DataTreeCandidate> changes) {
        LOG.debug("Enqueueing candidates {} for registration {}", changes, (Object)registration);
        this.notificationManager.submitNotifications((Object)registration, changes);
    }

    protected synchronized void registrationRemoved(AbstractDOMStoreTreeChangePublisher.Reg registration) {
        LOG.debug("Closing registration {}", (Object)registration);
    }

    Registration registerTreeChangeListener(YangInstanceIdentifier treeId, DOMDataTreeChangeListener listener, DataTreeSnapshot snapshot) {
        Registration reg = this.registerTreeChangeListener(treeId, listener);
        Optional preExistingData = snapshot.readNode(YangInstanceIdentifier.of());
        if (preExistingData.isEmpty()) {
            listener.onInitialData();
            return reg;
        }
        NormalizedNode data = (NormalizedNode)preExistingData.orElseThrow();
        if (treeId.isEmpty()) {
            if (data instanceof DataContainerNode) {
                DataContainerNode container = (DataContainerNode)data;
                if (container.isEmpty()) {
                    listener.onInitialData();
                    return reg;
                }
            } else {
                throw new IllegalStateException("Unexpected root node type " + String.valueOf(data.contract()));
            }
        }
        DataTreeCandidate candidate = DataTreeCandidates.fromNormalizedNode((YangInstanceIdentifier)YangInstanceIdentifier.of(), (NormalizedNode)data);
        InMemoryDOMStoreTreeChangePublisher publisher = new InMemoryDOMStoreTreeChangePublisher(this.notificationManager);
        publisher.registerTreeChangeListener(treeId, listener);
        if (!publisher.publishChange(candidate)) {
            listener.onInitialData();
        }
        return reg;
    }

    synchronized boolean publishChange(@NonNull DataTreeCandidate candidate) {
        return this.processCandidateTree(candidate);
    }
}

