/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.AbstractHierarchicalIdentifier;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.util.SingletonSet;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.FixedYangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.NIPv2;
import org.opendaylight.yangtools.yang.data.api.NIVv1;
import org.opendaylight.yangtools.yang.data.api.NIv1;
import org.opendaylight.yangtools.yang.data.api.StackedYangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YIDv1;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifierBuilder;

public abstract sealed class YangInstanceIdentifier
extends AbstractHierarchicalIdentifier<YangInstanceIdentifier, PathArgument>
permits FixedYangInstanceIdentifier, StackedYangInstanceIdentifier {
    private static final long serialVersionUID = 4L;
    private static final VarHandle TO_STRING_CACHE;
    private static final VarHandle HASH;
    private int hash;
    private transient String toStringCache = null;

    YangInstanceIdentifier() {
    }

    @Deprecated(since="11.0.0", forRemoval=true)
    public static final @NonNull YangInstanceIdentifier empty() {
        return YangInstanceIdentifier.of();
    }

    public static final @NonNull YangInstanceIdentifier of() {
        return FixedYangInstanceIdentifier.EMPTY_INSTANCE;
    }

    public static final @NonNull YangInstanceIdentifier of(PathArgument name) {
        return new FixedYangInstanceIdentifier((ImmutableList<PathArgument>)ImmutableList.of((Object)name));
    }

    public static final @NonNull YangInstanceIdentifier of(PathArgument ... path) {
        return YangInstanceIdentifier.of((ImmutableList<PathArgument>)ImmutableList.copyOf((Object[])path));
    }

    public static final @NonNull YangInstanceIdentifier of(ImmutableList<PathArgument> path) {
        return path.isEmpty() ? YangInstanceIdentifier.of() : new FixedYangInstanceIdentifier(path);
    }

    public static final @NonNull YangInstanceIdentifier of(Collection<? extends PathArgument> path) {
        return path.isEmpty() ? YangInstanceIdentifier.of() : YangInstanceIdentifier.of((ImmutableList<PathArgument>)ImmutableList.copyOf(path));
    }

    public static final @NonNull YangInstanceIdentifier of(Iterable<? extends PathArgument> path) {
        return YangInstanceIdentifier.of((ImmutableList<PathArgument>)ImmutableList.copyOf(path));
    }

    public static final @NonNull YangInstanceIdentifier of(QName name) {
        return YangInstanceIdentifier.of((PathArgument)new NodeIdentifier(name));
    }

    public static final @NonNull YangInstanceIdentifier of(QName ... path) {
        return YangInstanceIdentifier.of((ImmutableList<PathArgument>)((ImmutableList)Arrays.stream(path).map(NodeIdentifier::new).collect(ImmutableList.toImmutableList())));
    }

    @Deprecated(since="11.0.0", forRemoval=true)
    public static @NonNull YangInstanceIdentifier create(PathArgument pathArgument) {
        return YangInstanceIdentifier.of(pathArgument);
    }

    @Deprecated(since="11.0.0", forRemoval=true)
    public static @NonNull YangInstanceIdentifier create(PathArgument ... path) {
        return YangInstanceIdentifier.of(path);
    }

    @Deprecated(since="11.0.0", forRemoval=true)
    public static @NonNull YangInstanceIdentifier create(Iterable<? extends PathArgument> path) {
        return YangInstanceIdentifier.of(path);
    }

    abstract @NonNull YangInstanceIdentifier createRelativeIdentifier(int var1);

    abstract @Nullable List<PathArgument> tryPathArguments();

    abstract @Nullable List<PathArgument> tryReversePathArguments();

    public abstract boolean isEmpty();

    public abstract @NonNull YangInstanceIdentifier toOptimized();

    public abstract @Nullable YangInstanceIdentifier getParent();

    public abstract @NonNull YangInstanceIdentifier coerceParent();

    public abstract @NonNull YangInstanceIdentifier getAncestor(int var1);

    public abstract @NonNull List<PathArgument> getPathArguments();

    public abstract @NonNull List<PathArgument> getReversePathArguments();

    public abstract PathArgument getLastPathArgument();

    public static @NonNull YangInstanceIdentifier createReverse(Deque<PathArgument> pathTowardsRoot) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)pathTowardsRoot.size());
        pathTowardsRoot.descendingIterator().forEachRemaining(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return YangInstanceIdentifier.of((ImmutableList<PathArgument>)builder.build());
    }

    public static <T> @NonNull YangInstanceIdentifier createReverse(Deque<? extends T> stackTowardsRoot, Function<T, PathArgument> function) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)stackTowardsRoot.size());
        Iterator<T> it = stackTowardsRoot.descendingIterator();
        while (it.hasNext()) {
            builder.add((Object)function.apply(it.next()));
        }
        return YangInstanceIdentifier.of((ImmutableList<PathArgument>)builder.build());
    }

    boolean pathArgumentsEqual(YangInstanceIdentifier other) {
        return this.getPathArguments().equals(other.getPathArguments());
    }

    public final boolean equals(Object obj) {
        YangInstanceIdentifier other;
        return this == obj || obj instanceof YangInstanceIdentifier && this.pathArgumentsEqual(other = (YangInstanceIdentifier)((Object)obj));
    }

    public final @NonNull YangInstanceIdentifier node(QName name) {
        return this.node(new NodeIdentifier(name));
    }

    public final @NonNull YangInstanceIdentifier node(PathArgument arg) {
        return new StackedYangInstanceIdentifier(this, arg);
    }

    public Optional<YangInstanceIdentifier> relativeTo(YangInstanceIdentifier ancestor) {
        if (this == ancestor) {
            return Optional.of(YangInstanceIdentifier.of());
        }
        if (ancestor.isEmpty()) {
            return Optional.of(this);
        }
        Iterator<PathArgument> lit = this.getPathArguments().iterator();
        int common = 0;
        for (PathArgument element : ancestor.getPathArguments()) {
            if (!lit.hasNext() || !lit.next().equals(element)) {
                return Optional.empty();
            }
            ++common;
        }
        if (common == 0) {
            return Optional.of(this);
        }
        if (!lit.hasNext()) {
            return Optional.of(YangInstanceIdentifier.of());
        }
        return Optional.of(this.createRelativeIdentifier(common));
    }

    protected final Iterator<PathArgument> itemIterator() {
        return this.getPathArguments().iterator();
    }

    protected final Object writeReplace() {
        return new YIDv1(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.throwNSE();
    }

    public final String toString() {
        String ret = TO_STRING_CACHE.getAcquire(this);
        return ret != null ? ret : this.loadToString();
    }

    private String loadToString() {
        StringBuilder builder = new StringBuilder("/");
        PathArgument prev = null;
        for (PathArgument argument : this.getPathArguments()) {
            if (prev != null) {
                builder.append('/');
            }
            builder.append(argument.toRelativeString(prev));
            prev = argument;
        }
        String ret = builder.toString();
        String witness = TO_STRING_CACHE.compareAndExchangeRelease(this, null, ret);
        return witness == null ? ret : witness;
    }

    public final int hashCode() {
        int local = HASH.getAcquire(this);
        return local != 0 ? local : this.loadHashCode();
    }

    private static int hashCode(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return Arrays.hashCode(bytes);
        }
        if (value.getClass().isArray()) {
            int hash = 0;
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                hash += Objects.hashCode(Array.get(value, i));
            }
            return hash;
        }
        return value.hashCode();
    }

    private int loadHashCode() {
        int computed = this.computeHashCode();
        HASH.setRelease(this, computed);
        return computed;
    }

    abstract int computeHashCode();

    public static @NonNull InstanceIdentifierBuilder builder() {
        return new YangInstanceIdentifierBuilder();
    }

    public static @NonNull InstanceIdentifierBuilder builder(YangInstanceIdentifier origin) {
        return new YangInstanceIdentifierBuilder(origin.getPathArguments());
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            HASH = lookup.findVarHandle(YangInstanceIdentifier.class, "hash", Integer.TYPE);
            TO_STRING_CACHE = lookup.findVarHandle(YangInstanceIdentifier.class, "toStringCache", String.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static final class NodeIdentifier
    extends PathArgument {
        private static final long serialVersionUID = -2255888212390871347L;
        private static final LoadingCache<QName, NodeIdentifier> CACHE = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<QName, NodeIdentifier>(){

            public NodeIdentifier load(QName key) {
                return new NodeIdentifier(key);
            }
        });

        public NodeIdentifier(QName node) {
            super(node);
        }

        public static @NonNull NodeIdentifier create(QName node) {
            return (NodeIdentifier)CACHE.getUnchecked((Object)node);
        }

        @Override
        Object writeReplace() {
            return new NIv1(this);
        }
    }

    public static abstract sealed class PathArgument
    implements Identifier,
    Comparable<PathArgument>
    permits NodeIdentifier, NodeIdentifierWithPredicates, NodeWithValue {
        private static final long serialVersionUID = -4546547994250849340L;
        private final @NonNull QName nodeType;
        private volatile transient int hashValue;

        protected PathArgument(QName nodeType) {
            this.nodeType = Objects.requireNonNull(nodeType);
        }

        public final @NonNull QName getNodeType() {
            return this.nodeType;
        }

        public @NonNull String toRelativeString(PathArgument previous) {
            if (previous != null && this.nodeType.getModule().equals((Object)previous.nodeType.getModule())) {
                return this.nodeType.getLocalName();
            }
            return this.nodeType.toString();
        }

        @Override
        public int compareTo(PathArgument o) {
            return this.nodeType.compareTo(o.nodeType);
        }

        protected int hashCodeImpl() {
            return this.nodeType.hashCode();
        }

        public final int hashCode() {
            int local = this.hashValue;
            return local != 0 ? local : (this.hashValue = this.hashCodeImpl());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return this.nodeType.equals((Object)((PathArgument)obj).nodeType);
        }

        public String toString() {
            return this.nodeType.toString();
        }

        abstract Object writeReplace();
    }

    public static interface InstanceIdentifierBuilder
    extends Mutable {
        public @NonNull InstanceIdentifierBuilder node(PathArgument var1);

        public @NonNull InstanceIdentifierBuilder node(QName var1);

        public @NonNull InstanceIdentifierBuilder nodeWithKey(QName var1, Map<QName, Object> var2);

        public @NonNull InstanceIdentifierBuilder nodeWithKey(QName var1, QName var2, Object var3);

        public @NonNull InstanceIdentifierBuilder append(Collection<? extends PathArgument> var1);

        default public @NonNull InstanceIdentifierBuilder append(PathArgument ... args) {
            return this.append(Arrays.asList(args));
        }

        public @NonNull YangInstanceIdentifier build();
    }

    public static final class NodeWithValue<T>
    extends PathArgument {
        private static final long serialVersionUID = -3637456085341738431L;
        private final @NonNull T value;

        public NodeWithValue(QName node, T value) {
            super(node);
            this.value = Objects.requireNonNull(value);
        }

        public @NonNull T getValue() {
            return this.value;
        }

        @Override
        protected int hashCodeImpl() {
            return 31 * super.hashCodeImpl() + YangInstanceIdentifier.hashCode(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.deepEquals(this.value, ((NodeWithValue)obj).value);
        }

        @Override
        public String toString() {
            String string;
            String str = super.toString();
            T t = this.value;
            if (t instanceof byte[]) {
                byte[] bytes = (byte[])t;
                string = str + "[b64:" + Base64.getEncoder().encodeToString(bytes) + "]";
            } else {
                string = str + "[" + String.valueOf(this.value) + "]";
            }
            return string;
        }

        @Override
        public String toRelativeString(PathArgument previous) {
            return super.toRelativeString(previous) + "[" + String.valueOf(this.value) + "]";
        }

        @Override
        Object writeReplace() {
            return new NIVv1(this);
        }
    }

    public static abstract sealed class NodeIdentifierWithPredicates
    extends PathArgument {
        private static final long serialVersionUID = -4787195606494761540L;

        NodeIdentifierWithPredicates(QName node) {
            super(node);
        }

        public static @NonNull NodeIdentifierWithPredicates of(QName node) {
            return new Regular(node, (Map<QName, Object>)ImmutableMap.of());
        }

        public static @NonNull NodeIdentifierWithPredicates of(QName node, QName key, Object value) {
            return new Singleton(node, key, value);
        }

        public static @NonNull NodeIdentifierWithPredicates of(QName node, Map.Entry<QName, Object> entry) {
            return NodeIdentifierWithPredicates.of(node, entry.getKey(), entry.getValue());
        }

        public static @NonNull NodeIdentifierWithPredicates of(QName node, Map<QName, Object> keyValues) {
            return keyValues.size() == 1 ? NodeIdentifierWithPredicates.of(keyValues, node) : new Regular(node, ImmutableOffsetMap.unorderedCopyOf(keyValues));
        }

        public static @NonNull NodeIdentifierWithPredicates of(QName node, ImmutableOffsetMap<QName, Object> keyValues) {
            return keyValues.size() == 1 ? NodeIdentifierWithPredicates.of(keyValues, node) : new Regular(node, (Map<QName, Object>)keyValues);
        }

        private static @NonNull NodeIdentifierWithPredicates of(Map<QName, Object> keyValues, QName node) {
            return NodeIdentifierWithPredicates.of(node, keyValues.entrySet().iterator().next());
        }

        public abstract @NonNull Set<Map.Entry<QName, Object>> entrySet();

        public abstract @NonNull Set<QName> keySet();

        public abstract boolean containsKey(QName var1);

        public abstract @NonNull Collection<Object> values();

        @Beta
        public final @Nullable Object getValue(QName key) {
            return this.keyValue(Objects.requireNonNull(key));
        }

        @Beta
        public final <T> @Nullable T getValue(QName key, Class<T> valueClass) {
            return valueClass.cast(this.getValue(key));
        }

        public abstract int size();

        @Beta
        public abstract @NonNull Map<QName, Object> asMap();

        @Override
        protected final int hashCodeImpl() {
            int result = 31 * super.hashCodeImpl();
            for (Map.Entry<QName, Object> entry : this.entrySet()) {
                result += entry.getKey().hashCode() + YangInstanceIdentifier.hashCode(entry.getValue());
            }
            return result;
        }

        @Override
        public final boolean equals(Object obj) {
            return super.equals(obj) && this.equalMapping((NodeIdentifierWithPredicates)obj);
        }

        abstract boolean equalMapping(NodeIdentifierWithPredicates var1);

        abstract @Nullable Object keyValue(@NonNull QName var1);

        @Override
        public final String toString() {
            return super.toString() + "[" + String.valueOf(this.asMap()) + "]";
        }

        @Override
        public final String toRelativeString(PathArgument previous) {
            return super.toRelativeString(previous) + "[" + String.valueOf(this.asMap()) + "]";
        }

        @Override
        final Object writeReplace() {
            return new NIPv2(this);
        }

        private static final class Regular
        extends NodeIdentifierWithPredicates {
            private static final long serialVersionUID = 1L;
            private final @NonNull Map<QName, Object> keyValues;

            Regular(QName node, Map<QName, Object> keyValues) {
                super(node);
                this.keyValues = Objects.requireNonNull(keyValues);
            }

            @Override
            public Set<Map.Entry<QName, Object>> entrySet() {
                return this.keyValues.entrySet();
            }

            @Override
            public Set<QName> keySet() {
                return this.keyValues.keySet();
            }

            @Override
            public boolean containsKey(QName qname) {
                return this.keyValues.containsKey(Objects.requireNonNull(qname));
            }

            @Override
            public Collection<Object> values() {
                return this.keyValues.values();
            }

            @Override
            public int size() {
                return this.keyValues.size();
            }

            @Override
            public Map<QName, Object> asMap() {
                return this.keyValues;
            }

            @Override
            Object keyValue(QName qname) {
                return this.keyValues.get(qname);
            }

            @Override
            boolean equalMapping(NodeIdentifierWithPredicates other) {
                Map<QName, Object> otherKeyValues = ((Regular)other).keyValues;
                if (this.keyValues == otherKeyValues) {
                    return true;
                }
                if (this.keyValues.size() != otherKeyValues.size()) {
                    return false;
                }
                for (Map.Entry<QName, Object> entry : this.entrySet()) {
                    Object otherValue = otherKeyValues.get(entry.getKey());
                    if (otherValue != null && Objects.deepEquals(entry.getValue(), otherValue)) continue;
                    return false;
                }
                return true;
            }
        }

        @Beta
        public static final class Singleton
        extends NodeIdentifierWithPredicates {
            private static final long serialVersionUID = 1L;
            private final @NonNull QName key;
            private final @NonNull Object value;

            Singleton(QName node, QName key, Object value) {
                super(node);
                this.key = Objects.requireNonNull(key);
                this.value = Objects.requireNonNull(value);
            }

            public SingletonSet<Map.Entry<QName, Object>> entrySet() {
                return SingletonSet.of(this.singleEntry());
            }

            public SingletonSet<QName> keySet() {
                return SingletonSet.of((Object)this.key);
            }

            @Override
            public boolean containsKey(QName qname) {
                return this.key.equals((Object)Objects.requireNonNull(qname));
            }

            public SingletonSet<Object> values() {
                return SingletonSet.of((Object)this.value);
            }

            @Override
            public int size() {
                return 1;
            }

            public ImmutableMap<QName, Object> asMap() {
                return ImmutableMap.of((Object)this.key, (Object)this.value);
            }

            public @NonNull Map.Entry<QName, Object> singleEntry() {
                return new AbstractMap.SimpleImmutableEntry<QName, Object>(this.key, this.value);
            }

            @Override
            boolean equalMapping(NodeIdentifierWithPredicates other) {
                Singleton single = (Singleton)other;
                return this.key.equals((Object)single.key) && Objects.deepEquals(this.value, single.value);
            }

            @Override
            Object keyValue(QName qname) {
                return this.key.equals((Object)qname) ? this.value : null;
            }
        }
    }
}

