/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnydataNode;
import org.opendaylight.yangtools.yang.data.api.schema.AnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.SystemMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserLeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class NormalizedNodeWriter
implements Closeable,
Flushable {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedNodeWriter.class);
    private final @NonNull NormalizedNodeStreamWriter writer;

    protected NormalizedNodeWriter(NormalizedNodeStreamWriter writer) {
        this.writer = Objects.requireNonNull(writer);
    }

    protected final NormalizedNodeStreamWriter getWriter() {
        return this.writer;
    }

    public static NormalizedNodeWriter forStreamWriter(NormalizedNodeStreamWriter writer) {
        return NormalizedNodeWriter.forStreamWriter(writer, true);
    }

    public static NormalizedNodeWriter forStreamWriter(NormalizedNodeStreamWriter writer, boolean orderKeyLeaves) {
        return orderKeyLeaves ? new OrderedNormalizedNodeWriter(writer) : new NormalizedNodeWriter(writer);
    }

    public NormalizedNodeWriter write(NormalizedNode node) throws IOException {
        if (this.wasProcessedAsCompositeNode(node)) {
            return this;
        }
        if (this.wasProcessAsSimpleNode(node)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + String.valueOf(node));
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    protected boolean wasProcessAsSimpleNode(NormalizedNode node) throws IOException {
        NormalizedNode normalizedNode = node;
        Objects.requireNonNull(normalizedNode);
        NormalizedNode normalizedNode2 = normalizedNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LeafSetEntryNode.class, LeafNode.class, AnyxmlNode.class, AnydataNode.class}, (Object)normalizedNode2, n)) {
            case 0 -> {
                LeafSetEntryNode nodeAsLeafList = (LeafSetEntryNode)normalizedNode2;
                this.writer.startLeafSetEntryNode((YangInstanceIdentifier.NodeWithValue<?>)nodeAsLeafList.name());
                this.writer.scalarValue(nodeAsLeafList.body());
                this.writer.endNode();
                yield true;
            }
            case 1 -> {
                LeafNode nodeAsLeaf = (LeafNode)normalizedNode2;
                this.writer.startLeafNode((YangInstanceIdentifier.NodeIdentifier)nodeAsLeaf.name());
                this.writer.scalarValue(nodeAsLeaf.body());
                this.writer.endNode();
                yield true;
            }
            case 2 -> {
                AnyxmlNode anyxmlNode = (AnyxmlNode)normalizedNode2;
                Class model = anyxmlNode.bodyObjectModel();
                if (this.writer.startAnyxmlNode(anyxmlNode.name(), model)) {
                    Object value = node.body();
                    if (DOMSource.class.isAssignableFrom(model)) {
                        Verify.verify((boolean)(value instanceof DOMSource), (String)"Inconsistent anyxml node %s", (Object)anyxmlNode);
                        this.writer.domSourceValue((DOMSource)value);
                    } else {
                        this.writer.scalarValue(value);
                    }
                    this.writer.endNode();
                    yield true;
                }
                LOG.debug("Ignoring unhandled anyxml node {}", (Object)anyxmlNode);
                yield false;
            }
            case 3 -> {
                AnydataNode anydata = (AnydataNode)normalizedNode2;
                Class model = anydata.bodyObjectModel();
                if (this.writer.startAnydataNode(anydata.name(), model)) {
                    this.writer.scalarValue(anydata.body());
                    this.writer.endNode();
                    yield true;
                }
                LOG.debug("Writer {} does not support anydata in form of {}", (Object)this.writer, model);
                yield false;
            }
            default -> false;
        };
    }

    protected boolean writeChildren(Iterable<? extends NormalizedNode> children) throws IOException {
        for (NormalizedNode normalizedNode : children) {
            this.write(normalizedNode);
        }
        this.writer.endNode();
        return true;
    }

    protected boolean writeMapEntryNode(MapEntryNode node) throws IOException {
        this.writer.startMapEntryNode(node.name(), node.size());
        return this.writeChildren((Iterable<? extends NormalizedNode>)node.body());
    }

    protected boolean wasProcessedAsCompositeNode(NormalizedNode node) throws IOException {
        NormalizedNode normalizedNode = node;
        Objects.requireNonNull(normalizedNode);
        NormalizedNode normalizedNode2 = normalizedNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ContainerNode.class, MapEntryNode.class, UnkeyedListEntryNode.class, ChoiceNode.class, UnkeyedListNode.class, UserMapNode.class, SystemMapNode.class, UserLeafSetNode.class, SystemLeafSetNode.class}, (Object)normalizedNode2, n)) {
            case 0 -> {
                ContainerNode n = (ContainerNode)normalizedNode2;
                this.writer.startContainerNode((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
                yield this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
            }
            case 1 -> {
                MapEntryNode n = (MapEntryNode)normalizedNode2;
                yield this.writeMapEntryNode(n);
            }
            case 2 -> {
                UnkeyedListEntryNode n = (UnkeyedListEntryNode)normalizedNode2;
                this.writer.startUnkeyedListItem(n.name(), n.size());
                yield this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
            }
            case 3 -> {
                ChoiceNode n = (ChoiceNode)normalizedNode2;
                this.writer.startChoiceNode((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
                yield this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
            }
            case 4 -> {
                UnkeyedListNode n = (UnkeyedListNode)normalizedNode2;
                this.writer.startUnkeyedList((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
                yield this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
            }
            case 5 -> {
                UserMapNode n = (UserMapNode)normalizedNode2;
                this.writer.startOrderedMapNode((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
                yield this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
            }
            case 6 -> {
                SystemMapNode n = (SystemMapNode)normalizedNode2;
                this.writer.startMapNode((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
                yield this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
            }
            case 7 -> {
                UserLeafSetNode n = (UserLeafSetNode)normalizedNode2;
                this.writer.startOrderedLeafSet((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
                yield this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
            }
            case 8 -> {
                SystemLeafSetNode n = (SystemLeafSetNode)normalizedNode2;
                this.writer.startLeafSet((YangInstanceIdentifier.NodeIdentifier)n.name(), n.size());
                yield this.writeChildren((Iterable<? extends NormalizedNode>)n.body());
            }
            default -> false;
        };
    }

    private static final class OrderedNormalizedNodeWriter
    extends NormalizedNodeWriter {
        private static final Logger LOG = LoggerFactory.getLogger(OrderedNormalizedNodeWriter.class);

        OrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer) {
            super(writer);
        }

        @Override
        protected boolean writeMapEntryNode(MapEntryNode node) throws IOException {
            NormalizedNodeStreamWriter nnWriter = this.getWriter();
            nnWriter.startMapEntryNode(node.name(), node.size());
            Set<QName> qnames = node.name().keySet();
            for (QName qname : qnames) {
                DataContainerChild child = (DataContainerChild)node.childByArg(new YangInstanceIdentifier.NodeIdentifier(qname));
                if (child != null) {
                    this.write(child);
                    continue;
                }
                LOG.info("No child for key element {} found", (Object)qname);
            }
            return this.writeChildren(Iterables.filter((Iterable)node.body(), input -> {
                if (qnames.contains(input.name().getNodeType())) {
                    LOG.debug("Skipping key child {}", input);
                    return false;
                }
                return true;
            }));
        }
    }
}

