/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.dsbenchmark.listener.DsbenchmarkListener;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsbenchmarkListenerProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DsbenchmarkListenerProvider.class);
    private static final InstanceIdentifier<TestExec> TEST_EXEC_IID = InstanceIdentifier.builder(TestExec.class).build();
    private final List<DsbenchmarkListener> listeners = new ArrayList<DsbenchmarkListener>();
    private final List<Registration> registrations = new ArrayList<Registration>();
    private final DataBroker dataBroker;

    public DsbenchmarkListenerProvider(DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        LOG.debug("DsbenchmarkListenerProvider created");
    }

    public void createAndRegisterListeners(int numListeners) {
        for (int i = 0; i < numListeners; ++i) {
            DsbenchmarkListener listener = new DsbenchmarkListener();
            this.listeners.add(listener);
            this.registrations.add(this.dataBroker.registerTreeChangeListener(DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, TEST_EXEC_IID), (DataTreeChangeListener)listener));
            this.registrations.add(this.dataBroker.registerTreeChangeListener(DataTreeIdentifier.of((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, TEST_EXEC_IID), (DataTreeChangeListener)listener));
        }
        LOG.debug("DsbenchmarkListenerProvider created {} listeneres", (Object)numListeners);
    }

    public long getDataChangeCount() {
        long dataChanges = 0L;
        for (DsbenchmarkListener listener : this.listeners) {
            dataChanges += (long)listener.getNumDataChanges();
        }
        LOG.debug("DsbenchmarkListenerProvider , total data changes {}", (Object)dataChanges);
        return dataChanges;
    }

    public long getEventCountAndDestroyListeners() {
        long totalEvents = 0L;
        this.registrations.forEach(Registration::close);
        this.registrations.clear();
        for (DsbenchmarkListener listener : this.listeners) {
            totalEvents += (long)listener.getNumEvents();
        }
        this.listeners.clear();
        LOG.debug("DsbenchmarkListenerProvider destroyed listeneres, total events {}", (Object)totalEvents);
        return totalEvents;
    }
}

