/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ReusableStreamReceiver;
import org.opendaylight.yangtools.yang.data.codec.binfmt.DeletedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.ModifiedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.UnmodifiedRootDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ReusableImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataTreeCandidateInputOutput {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeCandidateInputOutput.class);
    private static final byte DELETE = 0;
    private static final byte SUBTREE_MODIFIED = 1;
    private static final byte UNMODIFIED = 2;
    private static final byte WRITE = 3;
    private static final byte APPEARED = 4;
    private static final byte DISAPPEARED = 5;

    private DataTreeCandidateInputOutput() {
    }

    public static @NonNull DataTreeCandidate readDataTreeCandidate(NormalizedNodeDataInput in) throws IOException {
        return DataTreeCandidateInputOutput.readDataTreeCandidate(in, (ReusableStreamReceiver)ReusableImmutableNormalizedNodeStreamWriter.create());
    }

    public static @NonNull DataTreeCandidate readDataTreeCandidate(NormalizedNodeDataInput in, ReusableStreamReceiver receiver) throws IOException {
        YangInstanceIdentifier rootPath = in.readYangInstanceIdentifier();
        byte type = in.readByte();
        DataTreeCandidateNode rootNode = switch (type) {
            case 4 -> ModifiedDataTreeCandidateNode.create(ModificationType.APPEARED, DataTreeCandidateInputOutput.readChildren(in, receiver));
            case 0 -> DeletedDataTreeCandidateNode.create();
            case 5 -> ModifiedDataTreeCandidateNode.create(ModificationType.DISAPPEARED, DataTreeCandidateInputOutput.readChildren(in, receiver));
            case 1 -> ModifiedDataTreeCandidateNode.create(ModificationType.SUBTREE_MODIFIED, DataTreeCandidateInputOutput.readChildren(in, receiver));
            case 3 -> DataTreeCandidateNodes.written((NormalizedNode)in.readNormalizedNode(receiver));
            case 2 -> UnmodifiedRootDataTreeCandidateNode.INSTANCE;
            default -> throw DataTreeCandidateInputOutput.unhandledNodeType(type);
        };
        return DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)rootPath, (DataTreeCandidateNode)rootNode);
    }

    public static void writeDataTreeCandidate(NormalizedNodeDataOutput out, DataTreeCandidate candidate) throws IOException {
        out.writeYangInstanceIdentifier(candidate.getRootPath());
        DataTreeCandidateNode node = candidate.getRootNode();
        switch (node.modificationType()) {
            case APPEARED: {
                out.writeByte(4);
                DataTreeCandidateInputOutput.writeChildren(out, node.childNodes());
                break;
            }
            case DELETE: {
                out.writeByte(0);
                break;
            }
            case DISAPPEARED: {
                out.writeByte(5);
                DataTreeCandidateInputOutput.writeChildren(out, node.childNodes());
                break;
            }
            case SUBTREE_MODIFIED: {
                out.writeByte(1);
                DataTreeCandidateInputOutput.writeChildren(out, node.childNodes());
                break;
            }
            case UNMODIFIED: {
                out.writeByte(2);
                break;
            }
            case WRITE: {
                out.writeByte(3);
                out.writeNormalizedNode((NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                break;
            }
            default: {
                throw DataTreeCandidateInputOutput.unhandledNodeType(node);
            }
        }
    }

    private static DataTreeCandidateNode readModifiedNode(ModificationType type, NormalizedNodeDataInput in, ReusableStreamReceiver receiver) throws IOException {
        YangInstanceIdentifier.PathArgument identifier = in.readPathArgument();
        Collection<DataTreeCandidateNode> children = DataTreeCandidateInputOutput.readChildren(in, receiver);
        if (children.isEmpty()) {
            LOG.debug("Modified node {} does not have any children, not instantiating it", (Object)identifier);
            return null;
        }
        return ModifiedDataTreeCandidateNode.create(identifier, type, children);
    }

    private static Collection<DataTreeCandidateNode> readChildren(NormalizedNodeDataInput in, ReusableStreamReceiver receiver) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return ImmutableList.of();
        }
        ArrayList<DataTreeCandidateNode> ret = new ArrayList<DataTreeCandidateNode>(size);
        for (int i = 0; i < size; ++i) {
            DataTreeCandidateNode child = DataTreeCandidateInputOutput.readNode(in, receiver);
            if (child == null) continue;
            ret.add(child);
        }
        return ret;
    }

    private static DataTreeCandidateNode readNode(NormalizedNodeDataInput in, ReusableStreamReceiver receiver) throws IOException {
        byte type = in.readByte();
        return switch (type) {
            case 4 -> DataTreeCandidateInputOutput.readModifiedNode(ModificationType.APPEARED, in, receiver);
            case 0 -> DeletedDataTreeCandidateNode.create(in.readPathArgument());
            case 5 -> DataTreeCandidateInputOutput.readModifiedNode(ModificationType.DISAPPEARED, in, receiver);
            case 1 -> DataTreeCandidateInputOutput.readModifiedNode(ModificationType.SUBTREE_MODIFIED, in, receiver);
            case 2 -> null;
            case 3 -> DataTreeCandidateNodes.written((NormalizedNode)in.readNormalizedNode(receiver));
            default -> throw DataTreeCandidateInputOutput.unhandledNodeType(type);
        };
    }

    private static void writeChildren(NormalizedNodeDataOutput out, Collection<DataTreeCandidateNode> children) throws IOException {
        out.writeInt(children.size());
        for (DataTreeCandidateNode child : children) {
            DataTreeCandidateInputOutput.writeNode(out, child);
        }
    }

    private static void writeNode(NormalizedNodeDataOutput out, DataTreeCandidateNode node) throws IOException {
        switch (node.modificationType()) {
            case APPEARED: {
                out.writeByte(4);
                out.writePathArgument(node.name());
                DataTreeCandidateInputOutput.writeChildren(out, node.childNodes());
                break;
            }
            case DELETE: {
                out.writeByte(0);
                out.writePathArgument(node.name());
                break;
            }
            case DISAPPEARED: {
                out.writeByte(5);
                out.writePathArgument(node.name());
                DataTreeCandidateInputOutput.writeChildren(out, node.childNodes());
                break;
            }
            case SUBTREE_MODIFIED: {
                out.writeByte(1);
                out.writePathArgument(node.name());
                DataTreeCandidateInputOutput.writeChildren(out, node.childNodes());
                break;
            }
            case WRITE: {
                out.writeByte(3);
                out.writeNormalizedNode((NormalizedNode)Verify.verifyNotNull((Object)node.dataAfter()));
                break;
            }
            case UNMODIFIED: {
                out.writeByte(2);
                break;
            }
            default: {
                throw DataTreeCandidateInputOutput.unhandledNodeType(node);
            }
        }
    }

    private static IllegalArgumentException unhandledNodeType(byte type) {
        return new IllegalArgumentException("Unhandled node type " + type);
    }

    private static IllegalArgumentException unhandledNodeType(DataTreeCandidateNode node) {
        return new IllegalArgumentException("Unhandled node type " + String.valueOf(node.modificationType()));
    }
}

