/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.binfmt;

import com.google.common.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.WritableObjects;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.binfmt.AbstractNormalizedNodeDataOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PotassiumDataOutput
extends AbstractNormalizedNodeDataOutput {
    private static final Logger LOG = LoggerFactory.getLogger(PotassiumDataOutput.class);
    private static final Object KEY_LEAF_STATE = new Object();
    private static final Object NO_ENDNODE_STATE = new Object();
    private static final TransformerFactory TF = TransformerFactory.newInstance();
    private final Deque<Object> stack = new ArrayDeque<Object>();
    private final Map<QNameModule, Integer> moduleCodeMap = new HashMap<QNameModule, Integer>();
    private final Map<String, Integer> stringCodeMap = new HashMap<String, Integer>();
    private final Map<QName, Integer> qnameCodeMap = new HashMap<QName, Integer>();

    PotassiumDataOutput(DataOutput output) {
        super(output);
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        QName qname;
        YangInstanceIdentifier.NodeIdentifierWithPredicates nip;
        Object current = this.stack.peek();
        if (current instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates && (nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)current).containsKey(qname = name.getNodeType())) {
            this.writeQNameNode(65, qname);
            this.stack.push(KEY_LEAF_STATE);
            return;
        }
        this.startSimpleNode((byte)1, (YangInstanceIdentifier.PathArgument)name);
    }

    public void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)6, (YangInstanceIdentifier.PathArgument)name);
    }

    public void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)7, (YangInstanceIdentifier.PathArgument)name);
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        if (this.matchesParentQName(name.getNodeType())) {
            this.output.writeByte(10);
            this.stack.push(NO_ENDNODE_STATE);
        } else {
            this.startSimpleNode((byte)10, (YangInstanceIdentifier.PathArgument)name);
        }
    }

    public void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)2, (YangInstanceIdentifier.PathArgument)name);
    }

    public void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)3, (YangInstanceIdentifier.PathArgument)name);
    }

    public void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startInheritedNode((byte)9, (YangInstanceIdentifier.PathArgument)name);
    }

    public void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)4, (YangInstanceIdentifier.PathArgument)name);
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        int size = identifier.size();
        if (size == 1) {
            this.startInheritedNode((byte)75, (YangInstanceIdentifier.PathArgument)identifier);
        } else if (size == 0) {
            this.startInheritedNode((byte)11, (YangInstanceIdentifier.PathArgument)identifier);
        } else if (size < 256) {
            this.startInheritedNode((byte)-117, (YangInstanceIdentifier.PathArgument)identifier);
            this.output.writeByte(size);
        } else {
            this.startInheritedNode((byte)-53, (YangInstanceIdentifier.PathArgument)identifier);
            this.output.writeInt(size);
        }
        this.writePredicates(identifier);
    }

    public void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)5, (YangInstanceIdentifier.PathArgument)name);
    }

    public void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.startQNameNode((byte)8, (YangInstanceIdentifier.PathArgument)name);
    }

    public boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        if (DOMSource.class.isAssignableFrom(objectModel)) {
            this.startSimpleNode((byte)12, (YangInstanceIdentifier.PathArgument)name);
            return true;
        }
        return false;
    }

    public void domSourceValue(DOMSource value) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            TF.newTransformer().transform(value, new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new IOException("Error writing anyXml", e);
        }
        this.writeValue(writer.toString());
    }

    public void endNode() throws IOException {
        if (this.stack.pop() instanceof YangInstanceIdentifier.PathArgument) {
            this.output.writeByte(0);
        }
    }

    public void scalarValue(Object value) throws IOException {
        if (KEY_LEAF_STATE.equals(this.stack.peek())) {
            LOG.trace("Inside a map entry key leaf, not emitting value {}", value);
        } else {
            this.writeObject(value);
        }
    }

    @Override
    short streamVersion() {
        return 5;
    }

    @Override
    void writeQNameInternal(QName qname) throws IOException {
        Integer code = this.qnameCodeMap.get(qname);
        if (code == null) {
            this.output.writeByte(22);
            this.encodeQName(qname);
        } else {
            this.writeQNameRef(code);
        }
    }

    @Override
    void writePathArgumentInternal(YangInstanceIdentifier.PathArgument pathArgument) throws IOException {
        YangInstanceIdentifier.PathArgument pathArgument2 = pathArgument;
        Objects.requireNonNull(pathArgument2);
        YangInstanceIdentifier.PathArgument pathArgument3 = pathArgument2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{YangInstanceIdentifier.NodeIdentifier.class, YangInstanceIdentifier.NodeIdentifierWithPredicates.class, YangInstanceIdentifier.NodeWithValue.class}, (Object)pathArgument3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                YangInstanceIdentifier.NodeIdentifier nid = (YangInstanceIdentifier.NodeIdentifier)pathArgument3;
                this.writeNodeIdentifier(nid);
                break;
            }
            case 1: {
                YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArgument3;
                this.writeNodeIdentifierWithPredicates(nip);
                break;
            }
            case 2: {
                YangInstanceIdentifier.NodeWithValue niv = (YangInstanceIdentifier.NodeWithValue)pathArgument3;
                this.writeNodeWithValue(niv);
            }
        }
    }

    private void writeNodeIdentifier(YangInstanceIdentifier.NodeIdentifier identifier) throws IOException {
        this.writePathArgumentQName(identifier.getNodeType(), (byte)1);
    }

    private void writeNodeIdentifierWithPredicates(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier) throws IOException {
        int size = identifier.size();
        if (size < 13) {
            this.writePathArgumentQName(identifier.getNodeType(), (byte)(2 | size << 4));
        } else if (size < 256) {
            this.writePathArgumentQName(identifier.getNodeType(), (byte)-94);
            this.output.writeByte(size);
        } else if (size < 65536) {
            this.writePathArgumentQName(identifier.getNodeType(), (byte)-62);
            this.output.writeShort(size);
        } else {
            this.writePathArgumentQName(identifier.getNodeType(), (byte)-30);
            this.output.writeInt(size);
        }
        this.writePredicates(identifier);
    }

    private void writePredicates(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier) throws IOException {
        for (Map.Entry e : identifier.entrySet()) {
            this.writeQNameInternal((QName)e.getKey());
            this.writeObject(e.getValue());
        }
    }

    private void writeNodeWithValue(YangInstanceIdentifier.NodeWithValue<?> identifier) throws IOException {
        this.writePathArgumentQName(identifier.getNodeType(), (byte)3);
        this.writeObject(identifier.getValue());
    }

    private void writePathArgumentQName(QName qname, byte typeHeader) throws IOException {
        Integer code = this.qnameCodeMap.get(qname);
        if (code != null) {
            int val = code;
            if (val < 256) {
                this.output.writeByte(typeHeader | 4);
                this.output.writeByte(val);
            } else if (val < 65792) {
                this.output.writeByte(typeHeader | 8);
                this.output.writeShort(val - 256);
            } else {
                this.output.writeByte(typeHeader | 0xC);
                this.output.writeInt(val);
            }
        } else {
            this.output.writeByte(typeHeader);
            this.encodeQName(qname);
        }
    }

    @Override
    void writeYangInstanceIdentifierInternal(YangInstanceIdentifier identifier) throws IOException {
        this.writeValue(identifier);
    }

    private void writeObject(@NonNull Object value) throws IOException {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Uint8.class, Uint16.class, Uint32.class, Uint64.class, QName.class, YangInstanceIdentifier.class, byte[].class, Empty.class, Set.class, Decimal64.class}, (Object)object2, n)) {
            case 0: {
                String val = (String)object2;
                this.writeValue(val);
                break;
            }
            case 1: {
                Boolean val = (Boolean)object2;
                this.writeValue(val);
                break;
            }
            case 2: {
                Byte val = (Byte)object2;
                this.writeValue(val);
                break;
            }
            case 3: {
                Short val = (Short)object2;
                this.writeValue(val);
                break;
            }
            case 4: {
                Integer val = (Integer)object2;
                this.writeValue(val);
                break;
            }
            case 5: {
                Long val = (Long)object2;
                this.writeValue(val);
                break;
            }
            case 6: {
                Uint8 val = (Uint8)object2;
                this.writeValue(val);
                break;
            }
            case 7: {
                Uint16 val = (Uint16)object2;
                this.writeValue(val);
                break;
            }
            case 8: {
                Uint32 val = (Uint32)object2;
                this.writeValue(val);
                break;
            }
            case 9: {
                Uint64 val = (Uint64)object2;
                this.writeValue(val);
                break;
            }
            case 10: {
                QName val = (QName)object2;
                this.writeQNameInternal(val);
                break;
            }
            case 11: {
                YangInstanceIdentifier val = (YangInstanceIdentifier)object2;
                this.writeValue(val);
                break;
            }
            case 12: {
                byte[] val = (byte[])object2;
                this.writeValue(val);
                break;
            }
            case 13: {
                Empty val = (Empty)object2;
                this.output.writeByte(2);
                break;
            }
            case 14: {
                Set val = (Set)object2;
                this.writeValue(val);
                break;
            }
            case 15: {
                Decimal64 val = (Decimal64)object2;
                this.output.writeByte(29);
                this.output.writeByte(val.scale());
                WritableObjects.writeLong((DataOutput)this.output, (long)val.unscaledValue());
                break;
            }
            default: {
                throw new IOException("Unhandled value type " + String.valueOf(value.getClass()));
            }
        }
    }

    private void writeValue(boolean value) throws IOException {
        this.output.writeByte(value ? 1 : 0);
    }

    private void writeValue(byte value) throws IOException {
        if (value != 0) {
            this.output.writeByte(3);
            this.output.writeByte(value);
        } else {
            this.output.writeByte(32);
        }
    }

    private void writeValue(short value) throws IOException {
        if (value != 0) {
            this.output.writeByte(4);
            this.output.writeShort(value);
        } else {
            this.output.writeByte(33);
        }
    }

    private void writeValue(int value) throws IOException {
        if ((value & 0xFFFF0000) != 0) {
            this.output.writeByte(5);
            this.output.writeInt(value);
        } else if (value != 0) {
            this.output.writeByte(41);
            this.output.writeShort(value);
        } else {
            this.output.writeByte(34);
        }
    }

    private void writeValue(long value) throws IOException {
        if ((value & 0xFFFFFFFF00000000L) != 0L) {
            this.output.writeByte(6);
            this.output.writeLong(value);
        } else if (value != 0L) {
            this.output.writeByte(43);
            this.output.writeInt((int)value);
        } else {
            this.output.writeByte(35);
        }
    }

    private void writeValue(Uint8 value) throws IOException {
        byte b = value.byteValue();
        if (b != 0) {
            this.output.writeByte(7);
            this.output.writeByte(b);
        } else {
            this.output.writeByte(36);
        }
    }

    private void writeValue(Uint16 value) throws IOException {
        short s = value.shortValue();
        if (s != 0) {
            this.output.writeByte(8);
            this.output.writeShort(s);
        } else {
            this.output.writeByte(37);
        }
    }

    private void writeValue(Uint32 value) throws IOException {
        int i = value.intValue();
        if ((i & 0xFFFF0000) != 0) {
            this.output.writeByte(9);
            this.output.writeInt(i);
        } else if (i != 0) {
            this.output.writeByte(42);
            this.output.writeShort(i);
        } else {
            this.output.writeByte(38);
        }
    }

    private void writeValue(Uint64 value) throws IOException {
        long l = value.longValue();
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            this.output.writeByte(10);
            this.output.writeLong(l);
        } else if (l != 0L) {
            this.output.writeByte(44);
            this.output.writeInt((int)l);
        } else {
            this.output.writeByte(39);
        }
    }

    private void writeValue(String value) throws IOException {
        if (value.isEmpty()) {
            this.output.writeByte(40);
        } else if (value.length() <= 16383) {
            this.output.writeByte(11);
            this.output.writeUTF(value);
        } else if (value.length() <= 0x100000) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            if (bytes.length < 65536) {
                this.output.writeByte(12);
                this.output.writeShort(bytes.length);
            } else {
                this.output.writeByte(13);
                this.output.writeInt(bytes.length);
            }
            this.output.write(bytes);
        } else {
            this.output.writeByte(14);
            this.output.writeInt(value.length());
            this.output.writeChars(value);
        }
    }

    private void writeValue(byte[] value) throws IOException {
        if (value.length < 128) {
            this.output.writeByte(-128 + value.length);
        } else if (value.length < 384) {
            this.output.writeByte(18);
            this.output.writeByte(value.length - 128);
        } else if (value.length < 65920) {
            this.output.writeByte(19);
            this.output.writeShort(value.length - 384);
        } else {
            this.output.writeByte(20);
            this.output.writeInt(value.length);
        }
        this.output.write(value);
    }

    private void writeValue(YangInstanceIdentifier value) throws IOException {
        List args = value.getPathArguments();
        int size = args.size();
        if (size > 31) {
            this.output.writeByte(21);
            this.output.writeInt(size);
        } else {
            this.output.writeByte(96 + size);
        }
        for (YangInstanceIdentifier.PathArgument arg : args) {
            this.writePathArgumentInternal(arg);
        }
    }

    private void writeValue(Set<?> value) throws IOException {
        int size = value.size();
        if (size < 29) {
            this.output.writeByte(64 + size);
        } else if (size < 285) {
            this.output.writeByte(93);
            this.output.writeByte(size - 29);
        } else if (size < 65821) {
            this.output.writeByte(94);
            this.output.writeShort(size - 285);
        } else {
            this.output.writeByte(95);
            this.output.writeInt(size);
        }
        for (Object bit : value) {
            Preconditions.checkArgument((boolean)(bit instanceof String), (String)"Expected value type to be String but was %s", bit);
            this.encodeString((String)bit);
        }
    }

    private boolean matchesParentQName(QName qname) {
        YangInstanceIdentifier.NodeIdentifier nid;
        Object current = this.stack.peek();
        return current instanceof YangInstanceIdentifier.NodeIdentifier && qname.equals((Object)(nid = (YangInstanceIdentifier.NodeIdentifier)current).getNodeType());
    }

    private void startInheritedNode(byte type, YangInstanceIdentifier.PathArgument name) throws IOException {
        QName qname = name.getNodeType();
        if (this.matchesParentQName(qname)) {
            this.output.write(type);
        } else {
            this.writeQNameNode(type, qname);
        }
        this.stack.push(name);
    }

    private void startQNameNode(byte type, YangInstanceIdentifier.PathArgument name) throws IOException {
        this.writeQNameNode(type, name.getNodeType());
        this.stack.push(name);
    }

    private void startSimpleNode(byte type, YangInstanceIdentifier.PathArgument name) throws IOException {
        this.writeQNameNode(type, name.getNodeType());
        this.stack.push(NO_ENDNODE_STATE);
    }

    private void writeQNameNode(int type, @NonNull QName qname) throws IOException {
        Integer code = this.qnameCodeMap.get(qname);
        if (code == null) {
            this.output.writeByte(type | 0x10);
            this.encodeQName(qname);
        } else {
            this.writeNodeType(type, code);
        }
    }

    private void writeNodeType(int type, int code) throws IOException {
        if (code <= 255) {
            this.output.writeByte(type | 0x20);
            this.output.writeByte(code);
        } else {
            this.output.writeByte(type | 0x30);
            this.output.writeInt(code);
        }
    }

    private void encodeQName(@NonNull QName qname) throws IOException {
        Integer prev = this.qnameCodeMap.put(qname, this.qnameCodeMap.size());
        if (prev != null) {
            throw new IOException("Internal coding error: attempted to re-encode " + String.valueOf(qname) + "%s already encoded as " + prev);
        }
        QNameModule module = qname.getModule();
        Integer code = this.moduleCodeMap.get(module);
        if (code == null) {
            this.moduleCodeMap.put(module, this.moduleCodeMap.size());
            this.encodeString(module.namespace().toString());
            Revision rev = module.revision();
            if (rev != null) {
                this.encodeString(rev.toString());
            } else {
                this.output.writeByte(40);
            }
        } else {
            this.writeModuleRef(code);
        }
        this.encodeString(qname.getLocalName());
    }

    private void encodeString(@NonNull String str) throws IOException {
        Integer code = this.stringCodeMap.get(str);
        if (code != null) {
            this.writeRef(code);
        } else {
            this.stringCodeMap.put(str, this.stringCodeMap.size());
            this.writeValue(str);
        }
    }

    private void writeQNameRef(int code) throws IOException {
        int val = code;
        if (val < 256) {
            this.output.writeByte(23);
            this.output.writeByte(val);
        } else if (val < 65792) {
            this.output.writeByte(24);
            this.output.writeShort(val - 256);
        } else {
            this.output.writeByte(25);
            this.output.writeInt(val);
        }
    }

    private void writeRef(int code) throws IOException {
        int val = code;
        if (val < 256) {
            this.output.writeByte(15);
            this.output.writeByte(val);
        } else if (val < 65792) {
            this.output.writeByte(16);
            this.output.writeShort(val - 256);
        } else {
            this.output.writeByte(17);
            this.output.writeInt(val);
        }
    }

    private void writeModuleRef(int code) throws IOException {
        int val = code;
        if (val < 256) {
            this.output.writeByte(26);
            this.output.writeByte(val);
        } else if (val < 65792) {
            this.output.writeByte(27);
            this.output.writeShort(val - 256);
        } else {
            this.output.writeByte(28);
            this.output.writeInt(val);
        }
    }
}

