/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.spi;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.CompatDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.CreatedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.DeletedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.ReplacedDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.spi.UnmodifiedDataTreeCandidateNode;

@NonNullByDefault
public final class ImmutableCandidateNodes {
    private ImmutableCandidateNodes() {
    }

    public static DataTreeCandidate.CandidateNode.Appeared appeared(NormalizedNode dataAfter, WithChildrenImpl children) {
        return new AppearedImpl(dataAfter, children);
    }

    public static DataTreeCandidate.CandidateNode.Appeared appeared(NormalizedNode dataAfter, Map<YangInstanceIdentifier.PathArgument, DataTreeCandidate.CandidateNode> children) {
        return ImmutableCandidateNodes.appeared(dataAfter, WithChildrenImpl.of(children));
    }

    public static DataTreeCandidate.CandidateNode.Compacted compacted(NormalizedNode dataAfter) {
        return new CompactedImpl(dataAfter);
    }

    public static DataTreeCandidate.CandidateNode.Created created(NormalizedNode dataAfter) {
        return new CreatedImpl(dataAfter);
    }

    public static DataTreeCandidate.CandidateNode.Deleted deleted(NormalizedNode dataBefore) {
        return new DeletedImpl(dataBefore);
    }

    public static DataTreeCandidate.CandidateNode.Disappeared disappeared(NormalizedNode dataBefore, WithChildrenImpl children) {
        return new DisappearedImpl(dataBefore, children);
    }

    public static DataTreeCandidate.CandidateNode.Disappeared disappeared(NormalizedNode dataBefore, Map<YangInstanceIdentifier.PathArgument, DataTreeCandidate.CandidateNode> children) {
        return ImmutableCandidateNodes.disappeared(dataBefore, WithChildrenImpl.of(children));
    }

    public static DataTreeCandidate.CandidateNode.Modified modified(NormalizedNode dataBefore, NormalizedNode dataAfter, WithChildrenImpl children) {
        return new ModifiedImpl(dataBefore, dataAfter, children);
    }

    public static DataTreeCandidate.CandidateNode.Modified modified(NormalizedNode dataBefore, NormalizedNode dataAfter, Map<YangInstanceIdentifier.PathArgument, DataTreeCandidate.CandidateNode> children) {
        return new ModifiedImpl(dataBefore, dataAfter, WithChildrenImpl.of(children));
    }

    public static DataTreeCandidate.CandidateNode.Replaced replaced(NormalizedNode dataBefore, NormalizedNode dataAfter) {
        return new ReplacedImpl(dataBefore, dataAfter);
    }

    public static DataTreeCandidate.CandidateNode.Unmodified unmodified(NormalizedNode dataAfter) {
        return new UnmodifiedImpl(dataAfter);
    }

    private record AppearedImpl(NormalizedNode dataAfter, WithChildrenImpl childrenImpl) implements DataTreeCandidate.CandidateNode.Appeared
    {
        AppearedImpl {
            Objects.requireNonNull(dataAfter);
            Objects.requireNonNull(childrenImpl);
        }

        public Collection<DataTreeCandidate.CandidateNode> children() {
            return this.childrenImpl.childrenImpl();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable DataTreeCandidate.CandidateNode modifiedChild(YangInstanceIdentifier.PathArgument arg) {
            return this.childrenImpl.modifiedChild(arg);
        }

        @Deprecated
        public DataTreeCandidateNode toLegacy() {
            return new CompatDataTreeCandidateNode<AppearedImpl>(ModificationType.APPEARED, this, null, this.dataAfter);
        }
    }

    public static interface WithChildrenImpl {
        public Collection<DataTreeCandidate.CandidateNode> childrenImpl();

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable DataTreeCandidate.CandidateNode modifiedChild(YangInstanceIdentifier.PathArgument var1);

        public static WithChildrenImpl of() {
            return MapWithChildrenImpl.EMPTY;
        }

        public static WithChildrenImpl of(DataTreeCandidate.CandidateNode child) {
            return new SingletonWithChildrenImpl(child);
        }

        public static WithChildrenImpl of(DataTreeCandidate.CandidateNode ... children) {
            return WithChildrenImpl.of(Arrays.asList(children));
        }

        public static WithChildrenImpl of(Collection<DataTreeCandidate.CandidateNode> children) {
            return WithChildrenImpl.of((Map<YangInstanceIdentifier.PathArgument, DataTreeCandidate.CandidateNode>)Maps.uniqueIndex(children, DataTreeCandidate.CandidateNode::name));
        }

        public static WithChildrenImpl of(Map<YangInstanceIdentifier.PathArgument, DataTreeCandidate.CandidateNode> map) {
            return switch (map.size()) {
                case 0 -> WithChildrenImpl.of();
                case 1 -> {
                    DataTreeCandidate.CandidateNode v1;
                    if (map instanceof SequencedMap) {
                        SequencedMap seq = (SequencedMap)map;
                        v1 = (DataTreeCandidate.CandidateNode)seq.sequencedValues().getFirst();
                    } else {
                        v1 = map.values().iterator().next();
                    }
                    DataTreeCandidate.CandidateNode child = v1;
                    yield WithChildrenImpl.of(child);
                }
                default -> new MapWithChildrenImpl(map);
            };
        }
    }

    private record CompactedImpl(NormalizedNode dataAfter) implements DataTreeCandidate.CandidateNode.Compacted
    {
        CompactedImpl {
            Objects.requireNonNull(dataAfter);
        }

        @Deprecated
        public DataTreeCandidateNode toLegacy() {
            return CreatedDataTreeCandidateNode.of(this.dataAfter);
        }
    }

    private record CreatedImpl(NormalizedNode dataAfter) implements DataTreeCandidate.CandidateNode.Created
    {
        CreatedImpl {
            Objects.requireNonNull(dataAfter);
        }

        @Deprecated
        public DataTreeCandidateNode toLegacy() {
            return CreatedDataTreeCandidateNode.of(this.dataAfter);
        }
    }

    private record DeletedImpl(NormalizedNode dataBefore) implements DataTreeCandidate.CandidateNode.Deleted
    {
        DeletedImpl {
            Objects.requireNonNull(dataBefore);
        }

        @Deprecated
        public DataTreeCandidateNode toLegacy() {
            return DeletedDataTreeCandidateNode.of(this.dataBefore);
        }
    }

    private record DisappearedImpl(NormalizedNode dataBefore, WithChildrenImpl map) implements DataTreeCandidate.CandidateNode.Disappeared
    {
        DisappearedImpl {
            Objects.requireNonNull(dataBefore);
            Objects.requireNonNull(map);
        }

        public Collection<DataTreeCandidate.CandidateNode> children() {
            return this.map.childrenImpl();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable DataTreeCandidate.CandidateNode modifiedChild(YangInstanceIdentifier.PathArgument arg) {
            return this.map.modifiedChild(arg);
        }

        @Deprecated
        public DataTreeCandidateNode toLegacy() {
            return new CompatDataTreeCandidateNode<DisappearedImpl>(ModificationType.DISAPPEARED, this, this.dataBefore, null);
        }
    }

    private record ModifiedImpl(NormalizedNode dataBefore, NormalizedNode dataAfter, WithChildrenImpl childrenImpl) implements DataTreeCandidate.CandidateNode.Modified
    {
        ModifiedImpl {
            Objects.requireNonNull(dataBefore);
            Objects.requireNonNull(dataAfter);
            Objects.requireNonNull(childrenImpl);
        }

        public Collection<DataTreeCandidate.CandidateNode> children() {
            return this.childrenImpl.childrenImpl();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable DataTreeCandidate.CandidateNode modifiedChild(YangInstanceIdentifier.PathArgument arg) {
            return this.childrenImpl.modifiedChild(arg);
        }

        @Deprecated
        public DataTreeCandidateNode toLegacy() {
            return new CompatDataTreeCandidateNode<ModifiedImpl>(ModificationType.SUBTREE_MODIFIED, this, this.dataBefore, this.dataAfter);
        }
    }

    private record ReplacedImpl(NormalizedNode dataBefore, NormalizedNode dataAfter) implements DataTreeCandidate.CandidateNode.Replaced
    {
        ReplacedImpl {
            Objects.requireNonNull(dataBefore);
            Objects.requireNonNull(dataAfter);
        }

        @Deprecated
        public DataTreeCandidateNode toLegacy() {
            return ReplacedDataTreeCandidateNode.of(this.dataBefore, this.dataAfter);
        }
    }

    private record UnmodifiedImpl(NormalizedNode dataAfter) implements DataTreeCandidate.CandidateNode.Unmodified
    {
        UnmodifiedImpl {
            Objects.requireNonNull(dataAfter);
        }

        @Deprecated
        public DataTreeCandidateNode toLegacy() {
            return UnmodifiedDataTreeCandidateNode.of(this.dataAfter);
        }
    }

    private record MapWithChildrenImpl(Map<YangInstanceIdentifier.PathArgument, DataTreeCandidate.CandidateNode> map) implements WithChildrenImpl
    {
        static final MapWithChildrenImpl EMPTY = new MapWithChildrenImpl(Map.of());

        MapWithChildrenImpl {
            Objects.requireNonNull(map);
        }

        @Override
        public Collection<DataTreeCandidate.CandidateNode> childrenImpl() {
            return this.map.values();
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable DataTreeCandidate.CandidateNode modifiedChild(YangInstanceIdentifier.PathArgument arg) {
            return this.map.get(arg);
        }
    }

    private record SingletonWithChildrenImpl(DataTreeCandidate.CandidateNode child) implements WithChildrenImpl
    {
        SingletonWithChildrenImpl {
            Objects.requireNonNull(child);
        }

        @Override
        public Collection<DataTreeCandidate.CandidateNode> childrenImpl() {
            return List.of(this.child);
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable DataTreeCandidate.CandidateNode modifiedChild(YangInstanceIdentifier.PathArgument arg) {
            return this.child.name().equals((Object)arg) ? this.child : null;
        }
    }
}

