/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.common.api;

import com.google.common.util.concurrent.FluentFuture;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.CI;

@NonNullByDefault
public interface CommitInfo
extends Serializable {
    public @Nullable UUID uuid();

    public @Nullable Instant instant();

    public static CommitInfo empty() {
        return CI.EMPTY;
    }

    public static FluentFuture<CommitInfo> emptyFluentFuture() {
        return CI.EMPTY_FUTURE;
    }

    public static CommitInfo of(UUID uuid) {
        return new CI(Objects.requireNonNull(uuid), null);
    }

    public static CommitInfo of(Instant instant) {
        return new CI(null, Objects.requireNonNull(instant));
    }

    public static CommitInfo of(UUID uuid, Instant instant) {
        return new CI(Objects.requireNonNull(uuid), Objects.requireNonNull(instant));
    }

    public static CommitInfo ofNullable(@Nullable UUID uuid, @Nullable Instant instant) {
        return CI.of(uuid, instant);
    }
}

