/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.memoryusage.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsageConstants;
import org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsageSupport;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

class MemoryUsageConfigurator
implements ManagedService,
MetaTypeProvider {
    private final MemoryUsageSupport support;
    private ObjectClassDefinition ocd;

    MemoryUsageConfigurator(MemoryUsageSupport support) {
        this.support = support;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        Object thresholdValue;
        if (properties == null) {
            properties = new Hashtable();
        }
        if ((thresholdValue = ((Dictionary)properties).get("felix.memoryusage.dump.threshold")) != null) {
            int threshold;
            if (thresholdValue instanceof Number) {
                threshold = ((Number)thresholdValue).intValue();
            } else {
                try {
                    threshold = Integer.parseInt(thresholdValue.toString());
                }
                catch (NumberFormatException nfe) {
                    throw this.thresholdFailure(thresholdValue);
                }
            }
            try {
                this.support.setThreshold(threshold);
            }
            catch (IllegalArgumentException iae) {
                throw this.thresholdFailure(iae.getMessage());
            }
        }
        this.support.setThreshold(-1);
        Object intervalValue = ((Dictionary)properties).get("felix.memoryusage.dump.interval");
        if (intervalValue != null) {
            int interval;
            if (intervalValue instanceof Number) {
                interval = ((Number)intervalValue).intValue();
            } else {
                try {
                    interval = Integer.parseInt(intervalValue.toString());
                }
                catch (NumberFormatException nfe) {
                    throw this.intervalFailure(intervalValue);
                }
            }
            try {
                this.support.setInterval(interval);
            }
            catch (IllegalArgumentException iae) {
                throw this.intervalFailure(iae.getMessage());
            }
        }
        this.support.setInterval(-1L);
        Object locationValue = ((Dictionary)properties).get("felix.memoryusage.dump.location");
        if (locationValue instanceof String) {
            this.support.setDumpLocation((String)locationValue);
        } else {
            this.support.setDumpLocation(null);
        }
    }

    public String[] getLocales() {
        return null;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        if (!"org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsageConfigurator".equals(id)) {
            return null;
        }
        if (this.ocd == null) {
            final ArrayList<AttributeDefinitionImpl> adList = new ArrayList<AttributeDefinitionImpl>();
            adList.add(new AttributeDefinitionImpl("felix.memoryusage.dump.threshold", "Dump Threshold", "Threshold at which to automatically create a memory dump as a percentage in the range 50 to 99 or zero to disable automatic dump creation.", 3, new String[]{String.valueOf(0)}, 0, null, null){

                public String validate(String value) {
                    try {
                        int threshold = Integer.parseInt(value);
                        if (!MemoryUsageConstants.isThresholdValid(threshold)) {
                            return "Dump Threshold must in the range 50 to 99 or zero";
                        }
                        return "";
                    }
                    catch (NumberFormatException nfe) {
                        return "Dump Threshhold must be numeric";
                    }
                }
            });
            adList.add(new AttributeDefinitionImpl("felix.memoryusage.dump.interval", "Dump Interval", "The minimum interval between two consecutive memory dumps being taken in seconds. This property allows the limitation of the number of memory dumps being taken. The default value for the interval is 6 hours. This means that a memory threshold event is ignored unless the last memory dump has been taken at least 6 hours earlier. This property allows limiting the number of memory dumps in case memory consumption is oscillating around the threshold point. The property must be an integer value or be parseable to an integer value. This should be a positive value or zero to force each memory threshold event to cause a memory dump (discouraged).", 3, new String[]{String.valueOf(21600000L)}, 0, null, null){

                public String validate(String value) {
                    try {
                        int interval = Integer.parseInt(value);
                        if (interval < 0) {
                            return "Dump Interval must be zero or a positive number";
                        }
                        return "";
                    }
                    catch (NumberFormatException nfe) {
                        return "Dump Interval must be numeric";
                    }
                }
            });
            adList.add(new AttributeDefinitionImpl("felix.memoryusage.dump.location", "Dumpe Location", "The filesystem location where heap dumps are stored. If this is null or empty (the default) the dumps are stored in " + this.support.getDefaultDumpLocation(), ""));
            this.ocd = new ObjectClassDefinition(){
                private final AttributeDefinition[] attrs;
                {
                    this.attrs = adList.toArray(new AttributeDefinition[adList.size()]);
                }

                public String getName() {
                    return "Apache Felix Web Console Memory Usage Plugin";
                }

                public InputStream getIcon(int arg0) {
                    return null;
                }

                public String getID() {
                    return "org.apache.felix.webconsole.plugins.memoryusage.internal.MemoryUsageConfigurator";
                }

                public String getDescription() {
                    return "Configuration of the Apache Felix Web Console Memory Usage Plugin.";
                }

                public AttributeDefinition[] getAttributeDefinitions(int filter) {
                    return filter == 2 ? null : this.attrs;
                }
            };
        }
        return this.ocd;
    }

    private ConfigurationException thresholdFailure(Object invalidValue) {
        return new ConfigurationException("felix.memoryusage.dump.threshold", "Invalid Dump Threshold value '" + invalidValue + "': Must be an integer number in the range " + 50 + " to " + 99 + " or zero to disable");
    }

    private ConfigurationException intervalFailure(Object invalidValue) {
        return new ConfigurationException("felix.memoryusage.dump.interval", "Invalid Dump Interval value '" + invalidValue + "': Must be a positive integer number or zero to disable");
    }

    private static class AttributeDefinitionImpl
    implements AttributeDefinition {
        private final String id;
        private final String name;
        private final String description;
        private final int type;
        private final String[] defaultValues;
        private final int cardinality;
        private final String[] optionLabels;
        private final String[] optionValues;

        AttributeDefinitionImpl(String id, String name, String description, String defaultValue) {
            this(id, name, description, 1, new String[]{defaultValue}, 0, null, null);
        }

        AttributeDefinitionImpl(String id, String name, String description, int type, String[] defaultValues, int cardinality, String[] optionLabels, String[] optionValues) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.type = type;
            this.defaultValues = defaultValues;
            this.cardinality = cardinality;
            this.optionLabels = optionLabels;
            this.optionValues = optionValues;
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public String[] getDefaultValue() {
            return this.defaultValues;
        }

        public String getDescription() {
            return this.description;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getOptionLabels() {
            return this.optionLabels;
        }

        public String[] getOptionValues() {
            return this.optionValues;
        }

        public int getType() {
            return this.type;
        }

        public String validate(String arg0) {
            return null;
        }
    }
}

