/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.transform;

import com.google.common.annotations.Beta;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.transform.QNameModuleReplacementFunction;
import org.opendaylight.yangtools.transform.QNameReplacementFunction;
import org.opendaylight.yangtools.transform.QNameTransformingStreamWriter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;

@Beta
public final class NormalizedNodeTransformations {
    private NormalizedNodeTransformations() {
    }

    public static NormalizedNode transformQNames(NormalizedNode original, Function<QName, QName> mapping) {
        NormalizationResultHolder result = new NormalizationResultHolder();
        NormalizedNodeStreamWriter nodeWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)result);
        NormalizedNodeStreamWriter transformWriter = QNameTransformingStreamWriter.fromFunction(nodeWriter, mapping);
        try {
            NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)transformWriter).write(original);
            return result.getResult().data();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static NormalizedNode replaceQNames(@NonNull NormalizedNode original, @NonNull Map<QName, QName> mapping) {
        return NormalizedNodeTransformations.transformQNames(original, new QNameReplacementFunction(mapping));
    }

    public static NormalizedNode replaceQNameModules(@NonNull NormalizedNode original, @NonNull Map<QNameModule, QNameModule> mapping) {
        return NormalizedNodeTransformations.transformQNames(original, new QNameModuleReplacementFunction(mapping));
    }
}

