/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.TransformerException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.source.SourceRepresentation;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.api.source.YinTextSource;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureSet;
import org.opendaylight.yangtools.yang.model.spi.source.YangIRSource;
import org.opendaylight.yangtools.yang.model.spi.source.YinDomSource;
import org.opendaylight.yangtools.yang.model.spi.source.YinXmlSource;
import org.opendaylight.yangtools.yang.parser.api.YangParser;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YinStatementStreamSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YinTextToDomTransformer;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementStreamSource;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;
import org.xml.sax.SAXException;

final class DefaultYangParser
implements YangParser {
    static final @NonNull ImmutableSet<Class<? extends SourceRepresentation>> REPRESENTATIONS = ImmutableSet.of(YangIRSource.class, YangTextSource.class, YinDomSource.class, YinXmlSource.class, YinTextSource.class);
    private final CrossSourceStatementReactor.BuildAction buildAction;

    DefaultYangParser(CrossSourceStatementReactor.BuildAction buildAction) {
        this.buildAction = Objects.requireNonNull(buildAction);
    }

    public ImmutableSet<Class<? extends SourceRepresentation>> supportedSourceRepresentations() {
        return REPRESENTATIONS;
    }

    public YangParser addSource(SourceRepresentation source) throws IOException, YangSyntaxErrorException {
        this.buildAction.addSource(DefaultYangParser.sourceToStatementStream(source));
        return this;
    }

    public YangParser addLibSource(SourceRepresentation source) throws IOException, YangSyntaxErrorException {
        this.buildAction.addLibSource(DefaultYangParser.sourceToStatementStream(source));
        return this;
    }

    public YangParser setSupportedFeatures(FeatureSet supportedFeatures) {
        this.buildAction.setSupportedFeatures(supportedFeatures);
        return this;
    }

    public YangParser setModulesWithSupportedDeviations(SetMultimap<QNameModule, QNameModule> modulesDeviatedByModules) {
        this.buildAction.setModulesWithSupportedDeviations(modulesDeviatedByModules);
        return this;
    }

    public List<DeclaredStatement<?>> buildDeclaredModel() throws YangParserException {
        try {
            return this.buildAction.build().getRootStatements();
        }
        catch (ReactorException e) {
            throw DefaultYangParser.decodeReactorException(e);
        }
    }

    public EffectiveModelContext buildEffectiveModel() throws YangParserException {
        try {
            return this.buildAction.buildEffective();
        }
        catch (ReactorException e) {
            throw DefaultYangParser.decodeReactorException(e);
        }
    }

    static YangParserException decodeReactorException(ReactorException reported) {
        return new YangParserException("Failed to assemble sources", (Throwable)reported);
    }

    static StatementStreamSource sourceToStatementStream(SourceRepresentation source) throws IOException, YangSyntaxErrorException {
        YangStatementStreamSource yangStatementStreamSource;
        SourceRepresentation sourceRepresentation = source;
        Objects.requireNonNull(sourceRepresentation);
        SourceRepresentation sourceRepresentation2 = sourceRepresentation;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{YangIRSource.class, YangTextSource.class, YinDomSource.class, YinTextSource.class, YinXmlSource.class}, (Object)sourceRepresentation2, n)) {
            case 0: {
                YangStatementStreamSource yangStatementStreamSource2;
                YangIRSource irSource = (YangIRSource)sourceRepresentation2;
                yangStatementStreamSource = yangStatementStreamSource2 = YangStatementStreamSource.create((YangIRSource)irSource);
                break;
            }
            case 1: {
                YangStatementStreamSource yangStatementStreamSource3;
                YangTextSource yangSource = (YangTextSource)sourceRepresentation2;
                yangStatementStreamSource = yangStatementStreamSource3 = YangStatementStreamSource.create((YangTextSource)yangSource);
                break;
            }
            case 2: {
                YinDomSource yinDom = (YinDomSource)sourceRepresentation2;
                StatementStreamSource statementStreamSource = YinStatementStreamSource.create((YinDomSource)yinDom);
                yangStatementStreamSource = statementStreamSource;
                break;
            }
            case 3: {
                YinTextSource yinText = (YinTextSource)sourceRepresentation2;
                try {
                    StatementStreamSource statementStreamSource = YinStatementStreamSource.create((YinDomSource)YinTextToDomTransformer.transformSource((YinTextSource)yinText));
                    yangStatementStreamSource = statementStreamSource;
                    break;
                }
                catch (SAXException e) {
                    throw new YangSyntaxErrorException(source.sourceId(), 0, 0, "Failed to parse XML text", (Throwable)e);
                }
            }
            case 4: {
                YinXmlSource yinXml = (YinXmlSource)sourceRepresentation2;
                try {
                    StatementStreamSource statementStreamSource = YinStatementStreamSource.create((YinXmlSource)yinXml);
                    yangStatementStreamSource = statementStreamSource;
                    break;
                }
                catch (TransformerException e) {
                    throw new YangSyntaxErrorException(source.sourceId(), 0, 0, "Failed to assemble in-memory representation", (Throwable)e);
                }
            }
            default: {
                throw new IllegalArgumentException("Unsupported source " + String.valueOf(source));
            }
        }
        return yangStatementStreamSource;
    }
}

