/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.spi.source.YangIRSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressModernizer
final class SourceIdMismatchDetector
implements Function<List<YangIRSource>, List<YangIRSource>> {
    private static final Logger LOG = LoggerFactory.getLogger(SourceIdMismatchDetector.class);
    private final Set<SourceIdentifier> sourceIdentifiers;

    SourceIdMismatchDetector(Set<SourceIdentifier> sourceIdentifiers) {
        this.sourceIdentifiers = Objects.requireNonNull(sourceIdentifiers);
    }

    public List<YangIRSource> apply(List<YangIRSource> input) {
        Iterator<SourceIdentifier> srcIt = this.sourceIdentifiers.iterator();
        LinkedHashMap<SourceIdentifier, YangIRSource> filtered = new LinkedHashMap<SourceIdentifier, YangIRSource>();
        for (YangIRSource irSchemaSource : input) {
            YangIRSource prev;
            SourceIdentifier expectedSId;
            SourceIdentifier realSId = irSchemaSource.sourceId();
            if (srcIt.hasNext() && !(expectedSId = srcIt.next()).equals((Object)realSId)) {
                LOG.warn("Source identifier mismatch for module \"{}\", requested as {} but actually is {}. Using actual id", new Object[]{expectedSId.name().getLocalName(), expectedSId, realSId});
            }
            if ((prev = filtered.put(realSId, irSchemaSource)) == null) continue;
            LOG.warn("Duplicate source for module {} detected in reactor", (Object)realSId);
        }
        return ImmutableList.copyOf(filtered.values());
    }
}

