/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.eos.common.api;

import com.google.common.collect.ImmutableMap;
import org.eclipse.jdt.annotation.NonNull;

public enum EntityOwnershipStateChange {
    LOCAL_OWNERSHIP_GRANTED(false, true, true),
    LOCAL_OWNERSHIP_LOST_NEW_OWNER(true, false, true),
    LOCAL_OWNERSHIP_LOST_NO_OWNER(true, false, false),
    LOCAL_OWNERSHIP_RETAINED_WITH_NO_CHANGE(true, true, true),
    REMOTE_OWNERSHIP_CHANGED(false, false, true),
    REMOTE_OWNERSHIP_LOST_NO_OWNER(false, false, false);

    private static final ImmutableMap<Key, EntityOwnershipStateChange> BY_KEY;
    private final boolean wasOwner;
    private final boolean isOwner;
    private final boolean hasOwner;

    private EntityOwnershipStateChange(boolean wasOwner, boolean isOwner, boolean hasOwner) {
        this.wasOwner = wasOwner;
        this.isOwner = isOwner;
        this.hasOwner = hasOwner;
    }

    public boolean wasOwner() {
        return this.wasOwner;
    }

    public boolean isOwner() {
        return this.isOwner;
    }

    public boolean hasOwner() {
        return this.hasOwner;
    }

    public String toString() {
        return this.name() + " [wasOwner=" + this.wasOwner + ", isOwner=" + this.isOwner + ", hasOwner=" + this.hasOwner + "]";
    }

    public static @NonNull EntityOwnershipStateChange from(boolean wasOwner, boolean isOwner, boolean hasOwner) {
        EntityOwnershipStateChange state = (EntityOwnershipStateChange)((Object)BY_KEY.get((Object)new Key(wasOwner, isOwner, hasOwner)));
        if (state != null) {
            return state;
        }
        throw new IllegalArgumentException("Invalid combination of wasOwner: %s, isOwner: %s, hasOwner: %s".formatted(wasOwner, isOwner, hasOwner));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EntityOwnershipStateChange e : EntityOwnershipStateChange.values()) {
            builder.put((Object)new Key(e.wasOwner, e.isOwner, e.hasOwner), (Object)e);
        }
        BY_KEY = builder.build();
    }

    private record Key(boolean wasOwner, boolean isOwner, boolean hasOwner) {
    }
}

