/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.api.query;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Beta
@NonNullByDefault
public final class DOMQueryPredicate
implements Immutable {
    private final YangInstanceIdentifier relativePath;
    private final Match match;

    private DOMQueryPredicate(YangInstanceIdentifier relativePath, Match match) {
        this.relativePath = Objects.requireNonNull(relativePath);
        this.match = Objects.requireNonNull(match);
    }

    public static DOMQueryPredicate of(YangInstanceIdentifier relativePath, Match match) {
        return new DOMQueryPredicate(relativePath, match);
    }

    public YangInstanceIdentifier relativePath() {
        return this.relativePath;
    }

    public Match match() {
        return this.match;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.relativePath).add("match", (Object)this.match).toString();
    }

    public static abstract class Match {
        Match() {
        }

        public static final Match exists() {
            return MatchExists.INSTACE;
        }

        public static final <T extends Comparable<T>> Match greaterThan(T value) {
            return new MatchGreaterThan<T>(value);
        }

        public static final <T extends Comparable<T>> Match greaterThanOrEqual(T value) {
            return new MatchGreaterThanOrEqual<T>(value);
        }

        public static final <T extends Comparable<T>> Match lessThan(T value) {
            return new MatchLessThan<T>(value);
        }

        public static final <T extends Comparable<T>> Match lessThanOrEqual(T value) {
            return new MatchLessThanOrEqual<T>(value);
        }

        public static final Match stringMatches(Pattern pattern) {
            return new MatchStringMatches(pattern);
        }

        public static final Match stringStartsWith(String str) {
            return new MatchStringStartsWith(str);
        }

        public static final Match stringEndsWith(String str) {
            return new MatchStringEndsWith(str);
        }

        public static final Match stringContains(String str) {
            return new MatchStringContains(str);
        }

        public static final <V> Match valueEquals(V value) {
            return new MatchValueEquals<V>(value);
        }

        public Match negate() {
            return new MatchNot(this);
        }

        public Match and(Match other) {
            return new MatchAll((ImmutableList<Match>)ImmutableList.of((Object)this, (Object)other));
        }

        public Match or(Match other) {
            return new MatchAny((ImmutableList<Match>)ImmutableList.of((Object)this, (Object)other));
        }

        public abstract boolean test(@Nullable NormalizedNode var1);

        final void appendTo(StringBuilder sb) {
            sb.append(this.op()).append('(');
            this.appendArgument(sb);
            sb.append(')');
        }

        void appendArgument(StringBuilder sb) {
        }

        abstract String op();

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendTo(sb);
            return sb.toString();
        }
    }

    private static abstract class AbstractMatchValue<T>
    extends AbstractMatch {
        private final @NonNull T value;

        AbstractMatchValue(T value) {
            this.value = Objects.requireNonNull(value);
        }

        final @NonNull T value() {
            return this.value;
        }

        @Override
        final void appendArgument(StringBuilder sb) {
            sb.append(this.value);
        }
    }

    private static abstract class AbstractMatchString
    extends AbstractMatchValue<String> {
        AbstractMatchString(String value) {
            super(value);
        }

        @Override
        final boolean testValue(@Nullable Object data) {
            return data instanceof String && this.testString((String)data);
        }

        abstract boolean testString(String var1);
    }

    private static abstract class AbstractMatchComparable<T extends Comparable<T>>
    extends AbstractMatchValue<T> {
        AbstractMatchComparable(T value) {
            super(value);
        }

        @Override
        final boolean testValue(@Nullable Object data) {
            return data != null && this.testCompare(((Comparable)this.value()).compareTo((Comparable)data));
        }

        abstract boolean testCompare(int var1);
    }

    private static abstract class AbstractMatch
    extends Match {
        AbstractMatch() {
        }

        @Override
        public final boolean test(@Nullable NormalizedNode data) {
            return data instanceof LeafNode ? this.testValue(((LeafNode)data).body()) : this.testValue(null);
        }

        abstract boolean testValue(@Nullable Object var1);
    }

    private static abstract class CompositeMatch
    extends Match {
        private final ImmutableList<Match> components;

        CompositeMatch(ImmutableList<Match> components) {
            this.components = Objects.requireNonNull(components);
        }

        final ImmutableList<Match> components() {
            return this.components;
        }

        final ImmutableList<Match> newComponents(Match nextComponent) {
            return ImmutableList.builderWithExpectedSize((int)(this.components.size() + 1)).addAll(this.components).add((Object)nextComponent).build();
        }

        @Override
        final void appendArgument(StringBuilder sb) {
            UnmodifiableIterator it = this.components.iterator();
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(", ").append(it.next());
            }
        }
    }

    private static final class MatchLessThanOrEqual<T extends Comparable<T>>
    extends AbstractMatchComparable<T> {
        MatchLessThanOrEqual(T value) {
            super(value);
        }

        @Override
        String op() {
            return "lte";
        }

        @Override
        boolean testCompare(int valueToData) {
            return valueToData >= 0;
        }
    }

    private static final class MatchLessThan<T extends Comparable<T>>
    extends AbstractMatchComparable<T> {
        MatchLessThan(T value) {
            super(value);
        }

        @Override
        String op() {
            return "lt";
        }

        @Override
        boolean testCompare(int valueToData) {
            return valueToData > 0;
        }
    }

    private static final class MatchGreaterThanOrEqual<T extends Comparable<T>>
    extends AbstractMatchComparable<T> {
        MatchGreaterThanOrEqual(T value) {
            super(value);
        }

        @Override
        String op() {
            return "gte";
        }

        @Override
        boolean testCompare(int valueToData) {
            return valueToData <= 0;
        }
    }

    private static final class MatchGreaterThan<T extends Comparable<T>>
    extends AbstractMatchComparable<T> {
        MatchGreaterThan(T value) {
            super(value);
        }

        @Override
        String op() {
            return "gt";
        }

        @Override
        boolean testCompare(int valueToData) {
            return valueToData < 0;
        }
    }

    private static final class MatchStringEndsWith
    extends AbstractMatchString {
        MatchStringEndsWith(String value) {
            super(value);
        }

        @Override
        String op() {
            return "endsWith";
        }

        @Override
        boolean testString(String str) {
            return str.endsWith((String)this.value());
        }
    }

    private static final class MatchStringStartsWith
    extends AbstractMatchString {
        MatchStringStartsWith(String value) {
            super(value);
        }

        @Override
        String op() {
            return "startsWith";
        }

        @Override
        boolean testString(String str) {
            return str.startsWith((String)this.value());
        }
    }

    private static final class MatchStringMatches
    extends AbstractMatch {
        private final Pattern pattern;

        MatchStringMatches(Pattern pattern) {
            this.pattern = Objects.requireNonNull(pattern);
        }

        @Override
        String op() {
            return "matches";
        }

        @Override
        void appendArgument(StringBuilder sb) {
            sb.append(this.pattern);
        }

        @Override
        boolean testValue(@Nullable Object data) {
            return data instanceof CharSequence && this.pattern.matcher((CharSequence)data).matches();
        }
    }

    private static final class MatchStringContains
    extends AbstractMatchString {
        MatchStringContains(String value) {
            super(value);
        }

        @Override
        String op() {
            return "contains";
        }

        @Override
        boolean testString(String str) {
            return str.contains((CharSequence)this.value());
        }
    }

    private static final class MatchValueEquals<T>
    extends AbstractMatchValue<T> {
        MatchValueEquals(T value) {
            super(value);
        }

        @Override
        String op() {
            return "eq";
        }

        @Override
        boolean testValue(@Nullable Object data) {
            return this.value().equals(data);
        }
    }

    private static final class MatchNot
    extends Match {
        private final Match match;

        MatchNot(Match match) {
            this.match = Objects.requireNonNull(match);
        }

        @Override
        public Match negate() {
            return this.match;
        }

        @Override
        public boolean test(@Nullable NormalizedNode data) {
            return !this.match.test(data);
        }

        @Override
        String op() {
            return "not";
        }

        @Override
        void appendArgument(StringBuilder sb) {
            this.match.appendTo(sb);
        }
    }

    private static final class MatchExists
    extends Match {
        static final MatchExists INSTACE = new MatchExists();

        private MatchExists() {
        }

        @Override
        public boolean test(@Nullable NormalizedNode data) {
            return data != null;
        }

        @Override
        String op() {
            return "exists";
        }
    }

    private static final class MatchAny
    extends CompositeMatch {
        MatchAny(ImmutableList<Match> components) {
            super(components);
        }

        @Override
        public MatchAny or(Match other) {
            return new MatchAny(this.newComponents(other));
        }

        @Override
        public boolean test(@Nullable NormalizedNode data) {
            for (Match component : this.components()) {
                if (!component.test(data)) continue;
                return true;
            }
            return false;
        }

        @Override
        String op() {
            return "anyOf";
        }
    }

    private static final class MatchAll
    extends CompositeMatch {
        MatchAll(ImmutableList<Match> components) {
            super(components);
        }

        @Override
        public MatchAll and(Match other) {
            return new MatchAll(this.newComponents(other));
        }

        @Override
        public boolean test(@Nullable NormalizedNode data) {
            for (Match component : this.components()) {
                if (component.test(data)) continue;
                return false;
            }
            return true;
        }

        @Override
        String op() {
            return "allOf";
        }
    }
}

