/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.raft.RaftEntryMeta;
import org.opendaylight.controller.cluster.raft.ReplicatedLog;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReplicatedLogImpl
implements ReplicatedLog {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReplicatedLogImpl.class);
    private final String logContext;
    private ArrayList<ReplicatedLogEntry> journal;
    private long snapshotIndex = -1L;
    private long snapshotTerm = -1L;
    private ArrayList<ReplicatedLogEntry> snapshottedJournal;
    private long previousSnapshotIndex = -1L;
    private long previousSnapshotTerm = -1L;
    private int dataSize = 0;

    protected AbstractReplicatedLogImpl(long snapshotIndex, long snapshotTerm, List<ReplicatedLogEntry> unAppliedEntries, String logContext) {
        this.snapshotIndex = snapshotIndex;
        this.snapshotTerm = snapshotTerm;
        this.logContext = logContext;
        this.journal = new ArrayList(unAppliedEntries.size());
        for (ReplicatedLogEntry entry : unAppliedEntries) {
            this.append(entry);
        }
    }

    protected AbstractReplicatedLogImpl() {
        this(-1L, -1L, Collections.emptyList(), "");
    }

    protected int adjustedIndex(long logEntryIndex) {
        if (this.snapshotIndex < 0L) {
            return (int)logEntryIndex;
        }
        return (int)(logEntryIndex - (this.snapshotIndex + 1L));
    }

    @Override
    public ReplicatedLogEntry get(long logEntryIndex) {
        int adjustedIndex = this.adjustedIndex(logEntryIndex);
        if (adjustedIndex < 0 || adjustedIndex >= this.journal.size()) {
            return null;
        }
        return this.journal.get(adjustedIndex);
    }

    @Override
    public ReplicatedLogEntry last() {
        if (this.journal.isEmpty()) {
            return null;
        }
        return this.journal.get(this.journal.size() - 1);
    }

    @Override
    public RaftEntryMeta lastMeta() {
        return this.last();
    }

    @Override
    public long lastIndex() {
        ReplicatedLogEntry last = this.last();
        return last != null ? last.index() : this.snapshotIndex;
    }

    @Override
    public long lastTerm() {
        ReplicatedLogEntry last = this.last();
        return last != null ? last.term() : this.snapshotTerm;
    }

    @Override
    public long removeFrom(long logEntryIndex) {
        int adjustedIndex = this.adjustedIndex(logEntryIndex);
        if (adjustedIndex < 0 || adjustedIndex >= this.journal.size()) {
            return -1L;
        }
        for (int i = adjustedIndex; i < this.journal.size(); ++i) {
            this.dataSize -= this.journal.get(i).size();
        }
        this.journal.subList(adjustedIndex, this.journal.size()).clear();
        return adjustedIndex;
    }

    @Override
    public boolean append(ReplicatedLogEntry replicatedLogEntry) {
        long lastIndex;
        long entryIndex = replicatedLogEntry.index();
        if (entryIndex > (lastIndex = this.lastIndex())) {
            this.journal.add(replicatedLogEntry);
            this.dataSize += replicatedLogEntry.size();
            return true;
        }
        LOG.warn("{}: Cannot append new entry - new index {} is not greater than the last index {}", new Object[]{this.logContext, entryIndex, lastIndex, new Exception("stack trace")});
        return false;
    }

    @Override
    public void increaseJournalLogCapacity(int amount) {
        this.journal.ensureCapacity(this.journal.size() + amount);
    }

    @Override
    public List<ReplicatedLogEntry> getFrom(long logEntryIndex) {
        return this.getFrom(logEntryIndex, this.journal.size(), -1L);
    }

    @Override
    public List<ReplicatedLogEntry> getFrom(long logEntryIndex, int maxEntries, long maxDataSize) {
        int adjustedIndex = this.adjustedIndex(logEntryIndex);
        int size = this.journal.size();
        if (adjustedIndex >= 0 && adjustedIndex < size) {
            int maxIndex = adjustedIndex + maxEntries;
            if (maxIndex > size) {
                maxIndex = size;
            }
            if (maxDataSize == -1L) {
                return new ArrayList<ReplicatedLogEntry>(this.journal.subList(adjustedIndex, maxIndex));
            }
            return this.copyJournalEntries(adjustedIndex, maxIndex, maxDataSize);
        }
        return Collections.emptyList();
    }

    private @NonNull List<ReplicatedLogEntry> copyJournalEntries(int fromIndex, int toIndex, long maxDataSize) {
        ArrayList<ReplicatedLogEntry> retList = new ArrayList<ReplicatedLogEntry>(toIndex - fromIndex);
        long totalSize = 0L;
        for (int i = fromIndex; i < toIndex; ++i) {
            ReplicatedLogEntry entry = this.journal.get(i);
            if ((totalSize += (long)entry.serializedSize()) > maxDataSize) {
                if (!retList.isEmpty()) break;
                retList.add(entry);
                break;
            }
            retList.add(entry);
        }
        return retList;
    }

    @Override
    public long size() {
        return this.journal.size();
    }

    @Override
    public int dataSize() {
        return this.dataSize;
    }

    @Override
    public boolean isPresent(long logEntryIndex) {
        if (logEntryIndex > this.lastIndex()) {
            return false;
        }
        int adjustedIndex = this.adjustedIndex(logEntryIndex);
        return adjustedIndex >= 0;
    }

    @Override
    public boolean isInSnapshot(long logEntryIndex) {
        return logEntryIndex >= 0L && logEntryIndex <= this.snapshotIndex && this.snapshotIndex != -1L;
    }

    @Override
    public long getSnapshotIndex() {
        return this.snapshotIndex;
    }

    @Override
    public long getSnapshotTerm() {
        return this.snapshotTerm;
    }

    @Override
    public void setSnapshotIndex(long snapshotIndex) {
        this.snapshotIndex = snapshotIndex;
    }

    @Override
    public void setSnapshotTerm(long snapshotTerm) {
        this.snapshotTerm = snapshotTerm;
    }

    @Override
    public void clear(int startIndex, int endIndex) {
        this.journal.subList(startIndex, endIndex).clear();
    }

    @Override
    public void snapshotPreCommit(long snapshotCapturedIndex, long snapshotCapturedTerm) {
        Preconditions.checkArgument((snapshotCapturedIndex >= this.snapshotIndex ? 1 : 0) != 0, (Object)"snapshotCapturedIndex must be greater than or equal to snapshotIndex");
        this.snapshottedJournal = new ArrayList(this.journal.size());
        List<ReplicatedLogEntry> snapshotJournalEntries = this.journal.subList(0, (int)(snapshotCapturedIndex - this.snapshotIndex));
        this.snapshottedJournal.addAll(snapshotJournalEntries);
        snapshotJournalEntries.clear();
        this.previousSnapshotIndex = this.snapshotIndex;
        this.setSnapshotIndex(snapshotCapturedIndex);
        this.previousSnapshotTerm = this.snapshotTerm;
        this.setSnapshotTerm(snapshotCapturedTerm);
    }

    @Override
    public void snapshotCommit(boolean updateDataSize) {
        this.snapshottedJournal = null;
        this.previousSnapshotIndex = -1L;
        this.previousSnapshotTerm = -1L;
        if (updateDataSize) {
            int newDataSize = 0;
            for (ReplicatedLogEntry logEntry : this.journal) {
                newDataSize += logEntry.size();
            }
            LOG.trace("{}: Updated dataSize from {} to {}", new Object[]{this.logContext, this.dataSize, newDataSize});
            this.dataSize = newDataSize;
        }
    }

    @Override
    public void snapshotRollback() {
        this.snapshottedJournal.addAll(this.journal);
        this.journal = this.snapshottedJournal;
        this.snapshottedJournal = null;
        this.snapshotIndex = this.previousSnapshotIndex;
        this.previousSnapshotIndex = -1L;
        this.snapshotTerm = this.previousSnapshotTerm;
        this.previousSnapshotTerm = -1L;
    }

    @VisibleForTesting
    ReplicatedLogEntry getAtPhysicalIndex(int index) {
        return this.journal.get(index);
    }
}

