/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.raft.messages.ServerChangeStatus;

public abstract class AbstractServerChangeReply
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String leaderHint;
    private final ServerChangeStatus status;

    AbstractServerChangeReply(@NonNull ServerChangeStatus status, @Nullable String leaderHint) {
        this.status = Objects.requireNonNull(status);
        this.leaderHint = leaderHint;
    }

    @VisibleForTesting
    public final @NonNull Optional<String> getLeaderHint() {
        return Optional.ofNullable(this.leaderHint);
    }

    public final @NonNull ServerChangeStatus getStatus() {
        return this.status;
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("status", (Object)this.status).add("leaderHint", (Object)this.leaderHint).toString();
    }
}

