/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.persisted;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.SerializationUtils;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.persisted.LE;

public final class SimpleReplicatedLogEntry
implements ReplicatedLogEntry,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int PROXY_SIZE = SerializationUtils.serialize((Serializable)new LE((Void)null)).length;
    private final long index;
    private final long term;
    private final Payload payload;
    private boolean persistencePending;

    public SimpleReplicatedLogEntry(long index, long term, Payload payload) {
        this.index = index;
        this.term = term;
        this.payload = Objects.requireNonNull(payload);
    }

    @Override
    public Payload getData() {
        return this.payload;
    }

    @Override
    public long index() {
        return this.index;
    }

    @Override
    public long term() {
        return this.term;
    }

    @Override
    public int size() {
        return this.payload.size();
    }

    @Override
    public int serializedSize() {
        return PROXY_SIZE + this.payload.serializedSize();
    }

    @Override
    public boolean isPersistencePending() {
        return this.persistencePending;
    }

    @Override
    public void setPersistencePending(boolean pending) {
        this.persistencePending = pending;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.payload.hashCode();
        result = 31 * result + (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SimpleReplicatedLogEntry)) return false;
        SimpleReplicatedLogEntry other = (SimpleReplicatedLogEntry)obj;
        if (this.index != other.index) return false;
        if (this.term != other.term) return false;
        if (!this.payload.equals(other.payload)) return false;
        return true;
    }

    public String toString() {
        return "SimpleReplicatedLogEntry [index=" + this.index + ", term=" + this.term + ", payload=" + String.valueOf(this.payload) + "]";
    }

    private Object writeReplace() {
        return new LE(this);
    }
}

