/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.spi;

import com.google.common.annotations.Beta;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.SourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractSchemaRepository
implements SchemaRepository,
SchemaSourceRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSchemaRepository.class);
    private final @GuardedBy(value={"this"}) Map<SourceIdentifier, ListMultimap<Class<? extends SourceRepresentation>, SchemaSourceRegistration>> sources = new HashMap<SourceIdentifier, ListMultimap<Class<? extends SourceRepresentation>, SchemaSourceRegistration>>();
    private final @GuardedBy(value={"this"}) List<SchemaListenerRegistration> listeners = new ArrayList<SchemaListenerRegistration>();

    private static <T extends SourceRepresentation> ListenableFuture<T> fetchSource(SourceIdentifier sourceId, Iterator<SchemaSourceRegistration> it) {
        SchemaSourceRegistration reg = it.next();
        SchemaSourceProvider<?> provider = reg.provider();
        return Futures.catchingAsync(provider.getSource(sourceId), Throwable.class, input -> {
            LOG.debug("Failed to acquire source from {}", (Object)reg, input);
            if (it.hasNext()) {
                return AbstractSchemaRepository.fetchSource(sourceId, it);
            }
            throw new MissingSchemaSourceException(sourceId, "All available providers exhausted", input);
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SourceRepresentation> ListenableFuture<T> getSchemaSource(final SourceIdentifier id, Class<T> representation) {
        ArrayList<SchemaSourceRegistration> sortedSchemaSourceRegistrations;
        AbstractSchemaRepository abstractSchemaRepository = this;
        synchronized (abstractSchemaRepository) {
            ListMultimap<Class<? extends SourceRepresentation>, SchemaSourceRegistration> srcs = this.sources.get(id);
            if (srcs == null) {
                return FluentFutures.immediateFailedFluentFuture((Throwable)new MissingSchemaSourceException(id, "No providers registered for source " + String.valueOf(id)));
            }
            sortedSchemaSourceRegistrations = new ArrayList<SchemaSourceRegistration>(srcs.get(representation));
        }
        sortedSchemaSourceRegistrations.sort(SchemaProviderCostComparator.INSTANCE);
        Iterator<SchemaSourceRegistration> regs = sortedSchemaSourceRegistrations.iterator();
        if (!regs.hasNext()) {
            return FluentFutures.immediateFailedFluentFuture((Throwable)new MissingSchemaSourceException(id, "No providers for source " + String.valueOf(id) + " representation " + String.valueOf(representation) + " available"));
        }
        ListenableFuture<T> fetchSourceFuture = AbstractSchemaRepository.fetchSource(id, regs);
        Futures.addCallback(fetchSourceFuture, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(T result) {
                for (SchemaListenerRegistration listener : AbstractSchemaRepository.this.listeners) {
                    ((SchemaSourceListener)listener.getInstance()).schemaSourceEncountered((SourceRepresentation)result);
                }
            }

            public void onFailure(Throwable t) {
                LOG.trace("Skipping notification for encountered source {}, fetching source failed", (Object)id, (Object)t);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return fetchSourceFuture;
    }

    private synchronized void addSource(SchemaSourceRegistration reg) {
        PotentialSchemaSource source = (PotentialSchemaSource)reg.getInstance();
        this.sources.computeIfAbsent(source.getSourceIdentifier(), ignored -> ArrayListMultimap.create()).put(source.getRepresentation(), (Object)reg);
        Set<PotentialSchemaSource<?>> reps = Collections.singleton(source);
        for (SchemaListenerRegistration l : this.listeners) {
            ((SchemaSourceListener)l.getInstance()).schemaSourceRegistered(reps);
        }
    }

    private synchronized void removeSource(SchemaSourceRegistration reg) {
        PotentialSchemaSource source = (PotentialSchemaSource)reg.getInstance();
        ListMultimap<Class<? extends SourceRepresentation>, SchemaSourceRegistration> m = this.sources.get(source.getSourceIdentifier());
        if (m != null) {
            m.remove(source.getRepresentation(), (Object)reg);
            for (SchemaListenerRegistration l : this.listeners) {
                ((SchemaSourceListener)l.getInstance()).schemaSourceUnregistered(source);
            }
            if (m.isEmpty()) {
                this.sources.remove(source.getSourceIdentifier());
            }
        }
    }

    @Override
    public <T extends SourceRepresentation> Registration registerSchemaSource(SchemaSourceProvider<? super T> provider, PotentialSchemaSource<T> source) {
        SchemaSourceRegistration ret = new SchemaSourceRegistration(source.cachedReference(), provider);
        this.addSource(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration registerSchemaSourceListener(SchemaSourceListener listener) {
        SchemaListenerRegistration ret = new SchemaListenerRegistration(listener);
        AbstractSchemaRepository abstractSchemaRepository = this;
        synchronized (abstractSchemaRepository) {
            ArrayList col = new ArrayList();
            for (ListMultimap<Class<? extends SourceRepresentation>, SchemaSourceRegistration> m : this.sources.values()) {
                for (SchemaSourceRegistration r : m.values()) {
                    col.add((PotentialSchemaSource)r.getInstance());
                }
            }
            listener.schemaSourceRegistered(col);
            this.listeners.add(ret);
        }
        return ret;
    }

    private final class SchemaSourceRegistration
    extends AbstractObjectRegistration<PotentialSchemaSource<?>> {
        private final @NonNull SchemaSourceProvider<?> provider;

        SchemaSourceRegistration(PotentialSchemaSource<?> source, SchemaSourceProvider<?> provider) {
            super(source);
            this.provider = Objects.requireNonNull(provider);
        }

        @NonNull SchemaSourceProvider<?> provider() {
            return this.provider;
        }

        protected void removeRegistration() {
            AbstractSchemaRepository.this.removeSource(this);
        }
    }

    private static final class SchemaProviderCostComparator
    implements Comparator<SchemaSourceRegistration>,
    Serializable {
        static final SchemaProviderCostComparator INSTANCE = new SchemaProviderCostComparator();
        private static final long serialVersionUID = 1L;

        private SchemaProviderCostComparator() {
        }

        @Override
        public int compare(SchemaSourceRegistration o1, SchemaSourceRegistration o2) {
            return ((PotentialSchemaSource)o1.getInstance()).getCost() - ((PotentialSchemaSource)o2.getInstance()).getCost();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private final class SchemaListenerRegistration
    extends AbstractObjectRegistration<SchemaSourceListener> {
        SchemaListenerRegistration(SchemaSourceListener listener) {
            super((Object)listener);
        }

        protected void removeRegistration() {
            AbstractSchemaRepository.this.listeners.remove((Object)this);
        }
    }
}

