/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.audit.layout;

import java.io.IOException;
import org.apache.karaf.audit.Event;
import org.apache.karaf.audit.layout.AbstractLayout;
import org.apache.karaf.audit.util.Buffer;
import org.apache.karaf.audit.util.FastDateFormat;

public class SimpleLayout
extends AbstractLayout {
    protected String hdr;
    protected FastDateFormat fastDateFormat = new FastDateFormat();

    public SimpleLayout() {
        super(new Buffer(Buffer.Format.Json, 4096));
        this.hdr = " " + this.hostName + " " + this.appName + " " + this.procId;
    }

    @Override
    protected void header(Event event) throws IOException {
        this.datetime(event.timestamp());
        this.buffer.append(this.hdr);
    }

    @Override
    protected void footer(Event event) throws IOException {
    }

    @Override
    protected void append(String key, Object val) throws IOException {
        if (val != null) {
            switch (key) {
                case "subject": 
                case "type": 
                case "subtype": {
                    this.buffer.append(' ').format(val);
                    break;
                }
                default: {
                    this.buffer.append(' ').append(key).append('=').append('\"').format(val).append('\"');
                }
            }
        }
    }

    protected void datetime(long millis) throws IOException {
        this.buffer.append(this.fastDateFormat.getDate(millis, "yyyy-MM-dd"));
        this.buffer.append('T');
        this.fastDateFormat.writeTime(millis, true, this.buffer);
        this.buffer.append(this.fastDateFormat.getDate(millis, "XXX"));
    }
}

