/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.audit.logger;

import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.karaf.audit.Event;
import org.apache.karaf.audit.EventLayout;
import org.apache.karaf.audit.EventLogger;

public class JulEventLogger
implements EventLogger {
    private final String logger;
    private final Level level;
    private final EventLayout layout;

    public JulEventLogger(String logger, String level, EventLayout layout) {
        this.logger = logger;
        this.level = Level.parse(level.toUpperCase(Locale.ENGLISH));
        this.layout = layout;
    }

    @Override
    public void write(Event event) throws IOException {
        this.getLogger(event.type() + "." + event.subtype()).log(this.getLevel(event), this.layout.format(event).toString());
    }

    protected Level getLevel(Event event) {
        return this.level;
    }

    protected Logger getLogger(String t) {
        return Logger.getLogger(this.logger + "." + t);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

