/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715;

import com.google.common.base.Preconditions;
import java.util.HexFormat;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.model.ietf.type.util.Ipv4Utils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DottedQuad;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.HexString;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Uuid;
import org.opendaylight.yangtools.binding.reflect.StringValueObjectFactory;

public final class IetfYangUtil {
    private static final int MAC_BYTE_LENGTH = 6;
    private static final HexFormat COLON_HEXFORMAT = HexFormat.ofDelimiter(":");
    private static final byte @NonNull [] EMPTY_BYTES = new byte[0];
    private static final StringValueObjectFactory<MacAddress> MAC_FACTORY = StringValueObjectFactory.create(MacAddress.class, (String)"00:00:00:00:00:00");
    private static final StringValueObjectFactory<PhysAddress> PHYS_FACTORY = StringValueObjectFactory.create(PhysAddress.class, (String)"00:00");
    private static final StringValueObjectFactory<HexString> HEX_FACTORY = StringValueObjectFactory.create(HexString.class, (String)"00");
    private static final StringValueObjectFactory<DottedQuad> QUAD_FACTORY = StringValueObjectFactory.create(DottedQuad.class, (String)"0.0.0.0");
    private static final StringValueObjectFactory<Uuid> UUID_FACTORY = StringValueObjectFactory.create(Uuid.class, (String)"f81d4fae-7dec-11d0-a765-00a0c91e6bf6");

    private IetfYangUtil() {
    }

    public static @NonNull MacAddress canonizeMacAddress(@NonNull MacAddress macAddress) {
        char[] input = macAddress.getValue().toCharArray();
        return IetfYangUtil.ensureLowerCase(input) ? (MacAddress)MAC_FACTORY.newInstance(String.valueOf(input)) : macAddress;
    }

    public static @NonNull MacAddress macAddressFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length == 6 ? 1 : 0) != 0, (String)"MAC address should have 6 bytes, not %s", (int)bytes.length);
        return (MacAddress)MAC_FACTORY.newInstance(COLON_HEXFORMAT.formatHex(bytes));
    }

    public static byte @NonNull [] macAddressBytes(@NonNull MacAddress macAddress) {
        return IetfYangUtil.stringToBytes(macAddress.getValue(), 6);
    }

    public static @NonNull PhysAddress canonizePhysAddress(@NonNull PhysAddress physAddress) {
        char[] input = physAddress.getValue().toCharArray();
        return IetfYangUtil.ensureLowerCase(input) ? (PhysAddress)PHYS_FACTORY.newInstance(String.valueOf(input)) : physAddress;
    }

    public static @NonNull PhysAddress physAddressFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length > 0 ? 1 : 0) != 0, (Object)"Physical address should have at least one byte");
        return (PhysAddress)PHYS_FACTORY.newInstance(COLON_HEXFORMAT.formatHex(bytes));
    }

    public static byte @NonNull [] physAddressBytes(@NonNull PhysAddress physAddress) {
        String str = physAddress.getValue();
        return str.isEmpty() ? EMPTY_BYTES : IetfYangUtil.stringToBytes(str, str.length() / 3 + 1);
    }

    public static @NonNull HexString hexStringFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length > 0 ? 1 : 0) != 0, (Object)"Hex string should have at least one byte");
        return (HexString)HEX_FACTORY.newInstance(COLON_HEXFORMAT.formatHex(bytes));
    }

    public static byte @NonNull [] hexStringBytes(@NonNull HexString hexString) {
        String str = hexString.getValue();
        return IetfYangUtil.stringToBytes(str, str.length() / 3 + 1);
    }

    public static @NonNull DottedQuad dottedQuadFor(byte @NonNull [] bytes) {
        Preconditions.checkArgument((bytes.length == 4 ? 1 : 0) != 0, (Object)"Dotted-quad should have 4 bytes");
        return (DottedQuad)QUAD_FACTORY.newInstance(Ipv4Utils.addressString((byte[])bytes));
    }

    public static @NonNull DottedQuad dottedQuadFor(int bits) {
        return (DottedQuad)QUAD_FACTORY.newInstance(Ipv4Utils.addressString((int)bits));
    }

    public static int dottedQuadBits(@NonNull DottedQuad dottedQuad) {
        String str = dottedQuad.getValue();
        return Ipv4Utils.addressBits((String)str, (int)str.length());
    }

    public static byte @NonNull [] dottedQuadBytes(@NonNull DottedQuad dottedQuad) {
        String str = dottedQuad.getValue();
        return Ipv4Utils.addressBytes((String)str, (int)str.length());
    }

    public static @NonNull Uuid uuidFor(@NonNull UUID uuid) {
        return (Uuid)UUID_FACTORY.newInstance(uuid.toString());
    }

    private static boolean ensureLowerCase(char @NonNull [] chars) {
        boolean ret = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < 'A' || c > 'F') continue;
            chars[i] = (char)(c + 32);
            ret = true;
        }
        return ret;
    }

    private static byte @NonNull [] stringToBytes(String str, int length) {
        byte[] ret = new byte[length];
        int i = 0;
        int base = 0;
        while (i < length) {
            ret[i] = (byte)((HexFormat.fromHexDigit(str.charAt(base)) << 4) + HexFormat.fromHexDigit(str.charAt(base + 1)));
            ++i;
            base += 3;
        }
        return ret;
    }
}

