/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.singleton.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipStateChange;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.singleton.api.ServiceGroupIdentifier;
import org.opendaylight.mdsal.singleton.impl.ServiceGroup;
import org.opendaylight.mdsal.singleton.impl.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PlaceholderServiceGroup
extends ServiceGroup {
    private static final Logger LOG = LoggerFactory.getLogger(PlaceholderServiceGroup.class);
    private final List<ServiceRegistration> services = new ArrayList<ServiceRegistration>(0);
    private final ServiceGroup previous;
    private final ListenableFuture<?> closeFuture;
    private volatile ServiceGroup successor;

    PlaceholderServiceGroup(ServiceGroup previous, ListenableFuture<?> closeFuture) {
        this.previous = Objects.requireNonNull(previous);
        this.closeFuture = Objects.requireNonNull(closeFuture);
    }

    public ServiceGroupIdentifier getIdentifier() {
        return (ServiceGroupIdentifier)this.previous.getIdentifier();
    }

    @Override
    void initialize() throws CandidateAlreadyRegisteredException {
        throw new UnsupportedOperationException("This should never be invoked");
    }

    @Override
    void registerService(ServiceRegistration reg) {
        this.verifyNoSuccessor();
        this.services.add(reg);
        LOG.debug("{}: added service {}", (Object)this, reg.getInstance());
    }

    @Override
    ListenableFuture<?> unregisterService(ServiceRegistration reg) {
        this.verifyNoSuccessor();
        this.services.remove((Object)reg);
        LOG.debug("{}: removed service {}", (Object)this, reg.getInstance());
        return null;
    }

    @Override
    void ownershipChanged(DOMEntity entity, EntityOwnershipStateChange change, boolean inJeopardy) {
        ServiceGroup local = this.successor;
        (local == null ? this.previous : local).ownershipChanged(entity, change, inJeopardy);
    }

    @Override
    ListenableFuture<?> closeClusterSingletonGroup() {
        ServiceGroup local = this.successor;
        return local == null ? this.closeFuture : local.closeClusterSingletonGroup();
    }

    List<ServiceRegistration> getServices() {
        this.verifyNoSuccessor();
        LOG.trace("{}: returning services {}", (Object)this, this.services);
        return this.services;
    }

    void setSuccessor(ServiceGroup successor) {
        this.verifyNoSuccessor();
        this.successor = (ServiceGroup)Verify.verifyNotNull((Object)successor);
        LOG.debug("{}: successor set to {}", (Object)this, (Object)successor);
    }

    private void verifyNoSuccessor() {
        Verify.verify((this.successor == null ? 1 : 0) != 0, (String)"Placeholder already superseded by %s", (Object)this.successor);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getIdentifier()).toString();
    }
}

