/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.xpath.api.YangExpr;

public sealed class YangFunctionCallExpr
implements YangExpr {
    private static final long serialVersionUID = 1L;
    private final QName name;

    private YangFunctionCallExpr(QName name) {
        this.name = Objects.requireNonNull(name);
    }

    public static YangFunctionCallExpr of(QName name) {
        return new YangFunctionCallExpr(name);
    }

    public static YangFunctionCallExpr of(QName name, YangExpr argument) {
        return new WithArgs(name, (List<YangExpr>)ImmutableList.of((Object)argument));
    }

    public static YangFunctionCallExpr of(QName name, List<YangExpr> arguments) {
        return arguments.isEmpty() ? YangFunctionCallExpr.of(name) : new WithArgs(name, arguments);
    }

    public final QName getName() {
        return this.name;
    }

    public List<YangExpr> getArguments() {
        return ImmutableList.of();
    }

    public final int hashCode() {
        return Objects.hash(this.getName(), this.getArguments());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof YangFunctionCallExpr)) return false;
        YangFunctionCallExpr other = (YangFunctionCallExpr)obj;
        if (!this.getName().equals((Object)other.getName())) return false;
        if (!this.getArguments().equals(other.getArguments())) return false;
        return true;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder().append(this.getName()).append('(');
        Iterator<YangExpr> it = this.getArguments().iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(", ").append(it.next());
            }
        }
        return sb.append(')').toString();
    }

    private static final class WithArgs
    extends YangFunctionCallExpr {
        private static final long serialVersionUID = 1L;
        private final ImmutableList<YangExpr> arguments;

        WithArgs(QName name, List<YangExpr> arguments) {
            super(name);
            this.arguments = ImmutableList.copyOf(arguments);
        }

        @Override
        public List<YangExpr> getArguments() {
            return this.arguments;
        }
    }
}

