/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.binding.api.ActionProviderService;
import org.opendaylight.mdsal.binding.api.ActionSpec;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingOperationFluentFuture;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionInstance;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.yangtools.binding.Action;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public final class ActionProviderServiceAdapter
extends AbstractBindingAdapter<DOMActionProviderService>
implements ActionProviderService {
    private static final Logger LOG = LoggerFactory.getLogger(ActionProviderServiceAdapter.class);
    static final BindingDOMAdapterBuilder.Factory<ActionProviderService> BUILDER_FACTORY = Builder::new;

    ActionProviderServiceAdapter(AdapterContext adapterContext, DOMActionProviderService delegate) {
        super(adapterContext, delegate);
    }

    public <P extends DataObject, A extends Action<? extends DataObjectIdentifier<P>, ?, ?>> Registration registerImplementation(ActionSpec<A, P> spec, A implementation, LogicalDatastoreType datastore, Set<? extends DataObjectIdentifier<P>> validNodes) {
        CurrentAdapterSerializer serializer = this.currentSerializer();
        SchemaNodeIdentifier.Absolute actionPath = serializer.getActionPath(spec);
        Impl impl = new Impl(this.adapterContext(), actionPath, spec.type(), implementation);
        DOMActionInstance instance = validNodes.isEmpty() ? DOMActionInstance.of((SchemaNodeIdentifier.Absolute)actionPath, (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{DOMDataTreeIdentifier.of((LogicalDatastoreType)datastore, (YangInstanceIdentifier)YangInstanceIdentifier.of())}) : DOMActionInstance.of((SchemaNodeIdentifier.Absolute)actionPath, validNodes.stream().map(node -> DOMDataTreeIdentifier.of((LogicalDatastoreType)datastore, (YangInstanceIdentifier)serializer.toYangInstanceIdentifier((DataObjectReference)node))).collect(Collectors.toUnmodifiableSet()));
        return ((DOMActionProviderService)this.getDelegate()).registerActionImplementation((DOMActionImplementation)impl, instance);
    }

    private static final class Impl
    implements DOMActionImplementation {
        private final Class<? extends Action<?, ?, ?>> actionInterface;
        private final AdapterContext adapterContext;
        private final Action implementation;
        private final YangInstanceIdentifier.NodeIdentifier outputName;

        Impl(AdapterContext adapterContext, SchemaNodeIdentifier.Absolute actionPath, Class<? extends Action<?, ?, ?>> actionInterface, Action<?, ?, ?> implementation) {
            this.adapterContext = Objects.requireNonNull(adapterContext);
            this.outputName = YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.operationOutputQName((QNameModule)actionPath.lastNodeIdentifier().getModule()));
            this.actionInterface = Objects.requireNonNull(actionInterface);
            this.implementation = Objects.requireNonNull(implementation);
        }

        public ListenableFuture<? extends DOMRpcResult> invokeAction(SchemaNodeIdentifier.Absolute type, DOMDataTreeIdentifier path, ContainerNode input) {
            CurrentAdapterSerializer codec = this.adapterContext.currentSerializer();
            DataObjectReference instance = codec.fromYangInstanceIdentifier(path.path());
            if (instance == null) {
                LOG.debug("Path {} is not representable in binding, rejecting invocation", (Object)path);
                return Futures.immediateFuture((Object)new DefaultDOMRpcResult(RpcResultBuilder.newError((ErrorType)ErrorType.APPLICATION, (ErrorTag)ErrorTag.INVALID_VALUE, (String)"Supplied path cannot be represented")));
            }
            if (!instance.isExact()) {
                LOG.debug("Path {} maps to a wildcard {}, rejecting invocation", (Object)path, (Object)instance);
                return Futures.immediateFuture((Object)new DefaultDOMRpcResult(RpcResultBuilder.newError((ErrorType)ErrorType.APPLICATION, (ErrorTag)ErrorTag.INVALID_VALUE, (String)"Supplied path does not identify a concrete instance")));
            }
            ListenableFuture userFuture = this.implementation.invoke(instance.toIdentifier(), codec.fromNormalizedNodeActionInput(this.actionInterface, input));
            if (userFuture instanceof BindingOperationFluentFuture) {
                return (BindingOperationFluentFuture)userFuture;
            }
            return new BindingOperationFluentFuture(userFuture, this.actionInterface, this.outputName, this.adapterContext);
        }
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<ActionProviderService> {
        Builder(AdapterContext adapterContext) {
            super(adapterContext);
        }

        @Override
        protected ActionProviderService createInstance(ClassToInstanceMap<DOMService<?, ?>> delegates) {
            return new ActionProviderServiceAdapter(this.adapterContext(), (DOMActionProviderService)delegates.getInstance(DOMActionProviderService.class));
        }

        @Override
        public Set<? extends Class<? extends DOMService<?, ?>>> getRequiredDelegates() {
            return ImmutableSet.of(DOMActionProviderService.class);
        }
    }
}

