/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.DataListener;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.data.codec.api.BindingAugmentationCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;

final class BindingDOMDataListenerAdapter<T extends DataObject>
implements DOMDataTreeChangeListener {
    private final AdapterContext adapterContext;
    private final DataListener<T> listener;

    BindingDOMDataListenerAdapter(AdapterContext adapterContext, DataListener<T> listener) {
        this.adapterContext = Objects.requireNonNull(adapterContext);
        this.listener = Objects.requireNonNull(listener);
    }

    public void onDataTreeChanged(List<DataTreeCandidate> changes) {
        DataTreeCandidate last = changes.get(changes.size() - 1);
        NormalizedNode after = last.getRootNode().dataAfter();
        this.listener.dataChangedTo(after == null ? null : (DataObject)this.deserialize(last.getRootPath(), after));
    }

    public void onInitialData() {
        this.listener.dataChangedTo(null);
    }

    private T deserialize(YangInstanceIdentifier path, @NonNull NormalizedNode data) {
        CurrentAdapterSerializer serializer = this.adapterContext.currentSerializer();
        CommonDataObjectCodecTreeNode codec = serializer.getSubtreeCodec(serializer.coerceInstanceIdentifier(path));
        if (codec instanceof BindingDataObjectCodecTreeNode) {
            BindingDataObjectCodecTreeNode dataObject = (BindingDataObjectCodecTreeNode)codec;
            return (T)((DataObject)dataObject.deserialize(data));
        }
        if (codec instanceof BindingAugmentationCodecTreeNode) {
            BindingAugmentationCodecTreeNode augmentation = (BindingAugmentationCodecTreeNode)codec;
            return (T)augmentation.filterFrom(data);
        }
        throw new IllegalStateException("Unhandled codec " + String.valueOf(codec));
    }
}

