/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.TransactionChainClosedException;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMReadTransactionAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMReadWriteTransactionAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMWriteTransactionAdapter;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainClosedException;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.common.Empty;

final class BindingDOMTransactionChainAdapter
implements TransactionChain,
Delegator<DOMTransactionChain> {
    private final @NonNull DOMTransactionChain delegate;
    private final @NonNull AdapterContext adapterContext;

    BindingDOMTransactionChainAdapter(DOMTransactionChain delegate, AdapterContext adapterContext) {
        this.delegate = Objects.requireNonNull(delegate);
        this.adapterContext = Objects.requireNonNull(adapterContext);
    }

    public DOMTransactionChain getDelegate() {
        return this.delegate;
    }

    public ReadTransaction newReadOnlyTransaction() {
        return new BindingDOMReadTransactionAdapter(this.adapterContext, BindingDOMTransactionChainAdapter.createTransaction(() -> ((DOMTransactionChain)this.delegate).newReadOnlyTransaction()));
    }

    public WriteTransaction newWriteOnlyTransaction() {
        return new BindingDOMWriteTransactionAdapter<DOMDataTreeWriteTransaction>(this.adapterContext, BindingDOMTransactionChainAdapter.createTransaction(() -> ((DOMTransactionChain)this.delegate).newWriteOnlyTransaction()));
    }

    public ReadWriteTransaction newReadWriteTransaction() {
        return new BindingDOMReadWriteTransactionAdapter(this.adapterContext, BindingDOMTransactionChainAdapter.createTransaction(() -> ((DOMTransactionChain)this.delegate).newReadWriteTransaction()));
    }

    public ListenableFuture<Empty> future() {
        return this.delegate.future();
    }

    public void close() {
        this.delegate.close();
    }

    private static <T> T createTransaction(Supplier<T> supplier) {
        try {
            return supplier.get();
        }
        catch (DOMTransactionChainClosedException e) {
            throw new TransactionChainClosedException("Transaction chain already closed", (Throwable)e);
        }
    }
}

