/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.osgi;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.opendaylight.mdsal.binding.api.ActionProviderService;
import org.opendaylight.mdsal.binding.api.ActionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.MountPointService;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.api.RpcService;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.AdaptingTracker;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiActionProviderService;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiActionService;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiDataBroker;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiMountPointService;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiNotificationPublishService;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiNotificationService;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiRpcProviderService;
import org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiRpcService;
import org.opendaylight.mdsal.binding.dom.adapter.spi.AdapterFactory;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public final class DynamicBindingAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicBindingAdapter.class);
    private List<AdaptingTracker<?, ?>> trackers = ImmutableList.of();
    @Reference
    AdapterFactory factory = null;
    @Reference(target="(component.factory=org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiActionService)")
    ComponentFactory<OSGiActionService> actionServiceFactory = null;
    @Reference(target="(component.factory=org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiActionProviderService)")
    ComponentFactory<OSGiActionProviderService> actionProviderServiceFactory = null;
    @Reference(target="(component.factory=org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiDataBroker)")
    ComponentFactory<OSGiDataBroker> dataBrokerFactory = null;
    @Reference(target="(component.factory=org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiMountPointService)")
    ComponentFactory<OSGiMountPointService> mountPointServiceFactory = null;
    @Reference(target="(component.factory=org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiNotificationService)")
    ComponentFactory<OSGiNotificationService> notificationServiceFactory = null;
    @Reference(target="(component.factory=org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiNotificationPublishService)")
    ComponentFactory<OSGiNotificationPublishService> notificationPublishServiceFactory = null;
    @Reference(target="(component.factory=org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiRpcConsumerRegistry)")
    ComponentFactory<OSGiRpcService> rpcServiceFactory = null;
    @Reference(target="(component.factory=org.opendaylight.mdsal.binding.dom.adapter.osgi.OSGiRpcProviderService)")
    ComponentFactory<OSGiRpcProviderService> rpcProviderServiceFactory = null;

    @Activate
    void activate(BundleContext ctx) {
        this.trackers = ImmutableList.of(new AdaptingTracker<DOMDataBroker, OSGiDataBroker>(ctx, DOMDataBroker.class, DataBroker.class, this.factory::createDataBroker, this.dataBrokerFactory), new AdaptingTracker<DOMMountPointService, OSGiMountPointService>(ctx, DOMMountPointService.class, MountPointService.class, this.factory::createMountPointService, this.mountPointServiceFactory), new AdaptingTracker<DOMNotificationService, OSGiNotificationService>(ctx, DOMNotificationService.class, NotificationService.class, this.factory::createNotificationService, this.notificationServiceFactory), new AdaptingTracker<DOMNotificationPublishService, OSGiNotificationPublishService>(ctx, DOMNotificationPublishService.class, NotificationPublishService.class, this.factory::createNotificationPublishService, this.notificationPublishServiceFactory), new AdaptingTracker<DOMRpcService, OSGiRpcService>(ctx, DOMRpcService.class, RpcService.class, this.factory::createRpcService, this.rpcServiceFactory), new AdaptingTracker<DOMRpcProviderService, OSGiRpcProviderService>(ctx, DOMRpcProviderService.class, RpcProviderService.class, this.factory::createRpcProviderService, this.rpcProviderServiceFactory), new AdaptingTracker<DOMActionService, OSGiActionService>(ctx, DOMActionService.class, ActionService.class, this.factory::createActionService, this.actionServiceFactory), new AdaptingTracker<DOMActionProviderService, OSGiActionProviderService>(ctx, DOMActionProviderService.class, ActionProviderService.class, this.factory::createActionProviderService, this.actionProviderServiceFactory));
        LOG.debug("Starting {} DOMService trackers", (Object)this.trackers.size());
        this.trackers.forEach(ServiceTracker::open);
        LOG.info("{} DOMService trackers started", (Object)this.trackers.size());
    }

    @Deactivate
    void deactivate() {
        LOG.debug("Stopping {} DOMService trackers", (Object)this.trackers.size());
        if (!this.trackers.isEmpty()) {
            this.trackers.forEach(ServiceTracker::close);
            LOG.info("{} DOMService trackers stopped", (Object)this.trackers.size());
        }
        this.trackers = ImmutableList.of();
    }
}

