/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.MoreObjects;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONValueWriter;

public final class DefaultJSONValueWriter
implements JSONValueWriter {
    private final JsonWriter writer;

    public DefaultJSONValueWriter(JsonWriter writer) {
        this.writer = Objects.requireNonNull(writer);
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.writer.value(value);
    }

    @Override
    public void writeEmpty() throws IOException {
        this.writer.beginArray().nullValue().endArray();
    }

    @Override
    public void writeNumber(Number value) throws IOException {
        this.writer.value(Objects.requireNonNull(value));
    }

    @Override
    public void writeString(String value) throws IOException {
        this.writer.value(Objects.requireNonNull(value));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("writer", (Object)this.writer).toString();
    }
}

