/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccess;
import org.opendaylight.controller.cluster.access.commands.TransactionSuccess;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;

final class RTS
implements TransactionSuccess.SerialForm<ReadTransactionSuccess> {
    private static final long serialVersionUID = 1L;
    private ReadTransactionSuccess message;

    public RTS() {
    }

    RTS(ReadTransactionSuccess message) {
        this.message = Objects.requireNonNull(message);
    }

    @Override
    public ReadTransactionSuccess message() {
        return (ReadTransactionSuccess)Verify.verifyNotNull((Object)this.message);
    }

    @Override
    public void setMessage(ReadTransactionSuccess message) {
        this.message = Objects.requireNonNull(message);
    }

    @Override
    public ReadTransactionSuccess readExternal(ObjectInput in, TransactionIdentifier target, long sequence) throws IOException {
        Optional<Object> data = in.readBoolean() ? Optional.of(NormalizedNodeDataInput.newDataInput((DataInput)in).readNormalizedNode()) : Optional.empty();
        return new ReadTransactionSuccess(target, sequence, data);
    }

    @Override
    public void writeExternal(ObjectOutput out, ReadTransactionSuccess msg) throws IOException {
        TransactionSuccess.SerialForm.super.writeExternal(out, msg);
        Optional<NormalizedNode> data = msg.getData();
        if (data.isPresent()) {
            out.writeBoolean(true);
            try (NormalizedNodeDataOutput nnout = msg.getVersion().getStreamVersion().newDataOutput((DataOutput)out);){
                nnout.writeNormalizedNode(data.orElseThrow());
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public Object readResolve() {
        return this.message();
    }
}

