/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.Verify;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class HI
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private LocalHistoryIdentifier identifier;

    public HI() {
    }

    HI(LocalHistoryIdentifier identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.identifier.getClientId().writeTo(out);
        WritableObjects.writeLongs((DataOutput)out, (long)this.identifier.getHistoryId(), (long)this.identifier.getCookie());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        ClientIdentifier clientId = ClientIdentifier.readFrom(in);
        byte header = WritableObjects.readLongHeader((DataInput)in);
        long historyId = WritableObjects.readFirstLong((DataInput)in, (byte)header);
        long cookie = WritableObjects.readSecondLong((DataInput)in, (byte)header);
        this.identifier = new LocalHistoryIdentifier(clientId, historyId, cookie);
    }

    private Object readResolve() {
        return Verify.verifyNotNull((Object)this.identifier);
    }
}

