/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.contract;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.BaseIdentity;
import org.opendaylight.yangtools.binding.BindingInstanceIdentifier;
import org.opendaylight.yangtools.binding.BitsTypeObject;
import org.opendaylight.yangtools.binding.EnumTypeObject;
import org.opendaylight.yangtools.binding.UnionTypeObject;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

public final class BuiltInType<T> {
    public static final @NonNull BuiltInType<@NonNull Byte> INT8 = new BuiltInType<Byte>("int8", Byte.class);
    public static final @NonNull BuiltInType<@NonNull Short> INT16 = new BuiltInType<Short>("int16", Short.class);
    public static final @NonNull BuiltInType<@NonNull Integer> INT32 = new BuiltInType<Integer>("int32", Integer.class);
    public static final @NonNull BuiltInType<@NonNull Long> INT64 = new BuiltInType<Long>("int64", Long.class);
    public static final @NonNull BuiltInType<@NonNull Uint8> UINT8 = new BuiltInType<Uint8>("uint8", Uint8.class);
    public static final @NonNull BuiltInType<@NonNull Uint16> UINT16 = new BuiltInType<Uint16>("uint16", Uint16.class);
    public static final @NonNull BuiltInType<@NonNull Uint32> UINT32 = new BuiltInType<Uint32>("uint32", Uint32.class);
    public static final @NonNull BuiltInType<@NonNull Uint64> UINT64 = new BuiltInType<Uint64>("uint64", Uint64.class);
    public static final @NonNull BuiltInType<@NonNull Decimal64> DECIMAL64 = new BuiltInType<Decimal64>("decimal64", Decimal64.class);
    public static final @NonNull BuiltInType<@NonNull String> STRING = new BuiltInType<String>("string", String.class);
    public static final @NonNull BuiltInType<@NonNull Boolean> BOOLEAN = new BuiltInType<Boolean>("boolean", Boolean.class);
    public static final @NonNull BuiltInType<@NonNull EnumTypeObject> ENUMERATION = new BuiltInType<EnumTypeObject>("enumeration", EnumTypeObject.class);
    public static final @NonNull BuiltInType<@NonNull BitsTypeObject> BITS = new BuiltInType<BitsTypeObject>("bits", BitsTypeObject.class);
    public static final @NonNull BuiltInType<byte @NonNull []> BINARY = new BuiltInType<byte[]>("binary", byte[].class);
    public static final @NonNull BuiltInType<@NonNull BaseIdentity> IDENTITYREF = new BuiltInType<BaseIdentity>("identityref", BaseIdentity.class);
    public static final @NonNull BuiltInType<@NonNull Empty> EMPTY = new BuiltInType<Empty>("empty", Empty.class);
    public static final @NonNull BuiltInType<@NonNull UnionTypeObject> UNION = new BuiltInType<UnionTypeObject>("union", UnionTypeObject.class);
    public static final @NonNull BuiltInType<@NonNull BindingInstanceIdentifier> INSTANCE_IDENTIFIER = new BuiltInType<BindingInstanceIdentifier>("instance-identifier", BindingInstanceIdentifier.class);
    private final @NonNull Class<T> javaClass;
    private final String str;

    private BuiltInType(@NonNull String str, @NonNull Class<T> javaClass) {
        this.str = Objects.requireNonNull(str);
        this.javaClass = Objects.requireNonNull(javaClass);
    }

    public static @NonNull BuiltInType<?> of(Object obj) {
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Uint8.class, Uint16.class, Uint32.class, Uint64.class, Decimal64.class, String.class, Boolean.class, EnumTypeObject.class, BitsTypeObject.class, byte[].class, BaseIdentity.class, Empty.class, UnionTypeObject.class, BindingInstanceIdentifier.class}, (Object)object2, n)) {
            case 0 -> {
                Byte value = (Byte)object2;
                yield INT8;
            }
            case 1 -> {
                Short value = (Short)object2;
                yield INT16;
            }
            case 2 -> {
                Integer value = (Integer)object2;
                yield INT32;
            }
            case 3 -> {
                Long value = (Long)object2;
                yield INT64;
            }
            case 4 -> {
                Uint8 value = (Uint8)object2;
                yield UINT8;
            }
            case 5 -> {
                Uint16 value = (Uint16)object2;
                yield UINT16;
            }
            case 6 -> {
                Uint32 value = (Uint32)object2;
                yield UINT32;
            }
            case 7 -> {
                Uint64 value = (Uint64)object2;
                yield UINT64;
            }
            case 8 -> {
                Decimal64 value = (Decimal64)object2;
                yield DECIMAL64;
            }
            case 9 -> {
                String value = (String)object2;
                yield STRING;
            }
            case 10 -> {
                Boolean value = (Boolean)object2;
                yield BOOLEAN;
            }
            case 11 -> {
                EnumTypeObject value = (EnumTypeObject)object2;
                yield ENUMERATION;
            }
            case 12 -> {
                BitsTypeObject value = (BitsTypeObject)object2;
                yield BITS;
            }
            case 13 -> {
                byte[] value = (byte[])object2;
                yield BINARY;
            }
            case 14 -> {
                BaseIdentity value = (BaseIdentity)object2;
                yield IDENTITYREF;
            }
            case 15 -> {
                Empty value = (Empty)object2;
                yield EMPTY;
            }
            case 16 -> {
                UnionTypeObject value = (UnionTypeObject)object2;
                yield UNION;
            }
            case 17 -> {
                BindingInstanceIdentifier value = (BindingInstanceIdentifier)object2;
                yield INSTANCE_IDENTIFIER;
            }
            default -> throw new IllegalArgumentException("Invalid value " + String.valueOf(obj));
        };
    }

    public static @NonNull Object checkValue(Object obj) {
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Long.class, Uint8.class, Uint16.class, Uint32.class, Uint64.class, Decimal64.class, String.class, Boolean.class, EnumTypeObject.class, BitsTypeObject.class, byte[].class, BaseIdentity.class, Empty.class, UnionTypeObject.class, BindingInstanceIdentifier.class}, (Object)object2, n)) {
            case 0 -> {
                @NonNull Byte value = (Byte)object2;
                yield value;
            }
            case 1 -> {
                @NonNull Short value = (Short)object2;
                yield value;
            }
            case 2 -> {
                @NonNull Integer value = (Integer)object2;
                yield value;
            }
            case 3 -> {
                @NonNull Long value = (Long)object2;
                yield value;
            }
            case 4 -> {
                @NonNull Uint8 value = (Uint8)object2;
                yield value;
            }
            case 5 -> {
                @NonNull Uint16 value = (Uint16)object2;
                yield value;
            }
            case 6 -> {
                @NonNull Uint32 value = (Uint32)object2;
                yield value;
            }
            case 7 -> {
                @NonNull Uint64 value = (Uint64)object2;
                yield value;
            }
            case 8 -> {
                @NonNull Decimal64 value = (Decimal64)object2;
                yield value;
            }
            case 9 -> {
                @NonNull String value = (String)object2;
                yield value;
            }
            case 10 -> {
                @NonNull Boolean value = (Boolean)object2;
                yield value;
            }
            case 11 -> {
                @NonNull EnumTypeObject value = (EnumTypeObject)object2;
                yield value;
            }
            case 12 -> {
                @NonNull BitsTypeObject value = (BitsTypeObject)object2;
                yield value;
            }
            case 13 -> {
                byte @NonNull [] value = (byte[])object2;
                yield value;
            }
            case 14 -> {
                @NonNull BaseIdentity value = (BaseIdentity)object2;
                yield value;
            }
            case 15 -> {
                @NonNull Empty value = (Empty)object2;
                yield value;
            }
            case 16 -> {
                @NonNull UnionTypeObject value = (UnionTypeObject)object2;
                yield value;
            }
            case 17 -> {
                @NonNull BindingInstanceIdentifier value = (BindingInstanceIdentifier)object2;
                yield value;
            }
            default -> throw new IllegalArgumentException("Invalid value " + String.valueOf(obj));
        };
    }

    public @NonNull Class<T> javaClass() {
        return this.javaClass;
    }

    public @NonNull T castValue(Object obj) {
        return Objects.requireNonNull(this.javaClass.cast(obj));
    }

    public int hashCode() {
        return this.str.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof BuiltInType)) return false;
        BuiltInType other = (BuiltInType)obj;
        if (!this.javaClass.equals(other.javaClass)) return false;
        if (!this.str.equals(other.str)) return false;
        return true;
    }

    public String toString() {
        return "YANG " + this.str;
    }
}

