/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.lib;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.Augmentation;

public abstract class AbstractAugmentable<T extends Augmentable<T>>
implements Augmentable<T> {
    private final @NonNull ImmutableMap<Class<? extends Augmentation<T>>, Augmentation<T>> augmentations;

    protected AbstractAugmentable() {
        this.augmentations = ImmutableMap.of();
    }

    protected AbstractAugmentable(Map<Class<? extends Augmentation<T>>, Augmentation<T>> augmentations) {
        this.augmentations = ImmutableMap.copyOf(augmentations);
    }

    protected AbstractAugmentable(ImmutableMap<Class<? extends Augmentation<T>>, Augmentation<T>> augmentations) {
        this.augmentations = Objects.requireNonNull(augmentations);
    }

    protected AbstractAugmentable(AbstractAugmentable<T> other) {
        this(other.augmentations);
    }

    @Override
    public final <A extends Augmentation<T>> A augmentation(Class<A> augmentationType) {
        return (A)((Augmentation)this.augmentations.get(Objects.requireNonNull(augmentationType)));
    }

    @Override
    public final ImmutableMap<Class<? extends Augmentation<T>>, Augmentation<T>> augmentations() {
        return this.augmentations;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();
}

