/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.KeyAware;

@Beta
public final class BindingMap {
    private BindingMap() {
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(V v1) {
        return Map.of(v1.key(), v1);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(V v1, V v2) {
        return Map.of(v1.key(), v1, v2.key(), v2);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(V v1, V v2, V v3) {
        return Map.of(v1.key(), v1, v2.key(), v2, v3.key(), v3);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(V v1, V v2, V v3, V v4) {
        return Map.of(v1.key(), v1, v2.key(), v2, v3.key(), v3, v4.key(), v4);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(V v1, V v2, V v3, V v4, V v5) {
        return Map.of(v1.key(), v1, v2.key(), v2, v3.key(), v3, v4.key(), v4, v5.key(), v5);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(V v1, V v2, V v3, V v4, V v5, V v6) {
        return Map.of(v1.key(), v1, v2.key(), v2, v3.key(), v3, v4.key(), v4, v5.key(), v5, v6.key(), v6);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(V v1, V v2, V v3, V v4, V v5, V v6, V v7) {
        return Map.of(v1.key(), v1, v2.key(), v2, v3.key(), v3, v4.key(), v4, v5.key(), v5, v6.key(), v6, v7.key(), v7);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(V v1, V v2, V v3, V v4, V v5, V v6, V v7, V v8) {
        return Map.of(v1.key(), v1, v2.key(), v2, v3.key(), v3, v4.key(), v4, v5.key(), v5, v6.key(), v6, v7.key(), v7, v8.key(), v8);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(V v1, V v2, V v3, V v4, V v5, V v6, V v7, V v8, V v9) {
        return Map.of(v1.key(), v1, v2.key(), v2, v3.key(), v3, v4.key(), v4, v5.key(), v5, v6.key(), v6, v7.key(), v7, v8.key(), v8, v9.key(), v9);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(V v1, V v2, V v3, V v4, V v5, V v6, V v7, V v8, V v9, V v10) {
        return Map.of(v1.key(), v1, v2.key(), v2, v3.key(), v3, v4.key(), v4, v5.key(), v5, v6.key(), v6, v7.key(), v7, v8.key(), v8, v9.key(), v9, v10.key(), v10);
    }

    @SafeVarargs
    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(V ... values) {
        return BindingMap.of(Arrays.asList(values));
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> of(Collection<V> values) {
        return values.stream().collect(BindingMap.toMap());
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Collector<V, ?, ? extends Map<K, V>> toMap() {
        return Collectors.toUnmodifiableMap(KeyAware::key, v -> v);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Builder<K, V> builder() {
        return BindingMap.builder(4);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Builder<K, V> builder(int expectedSize) {
        return new UnorderedBuilder(expectedSize);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> ordered(V v1, V v2) {
        return ImmutableMap.of(v1.key(), v1, v2.key(), v2);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> ordered(V v1, V v2, V v3) {
        return ImmutableMap.of(v1.key(), v1, v2.key(), v2, v3.key(), v3);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> ordered(V v1, V v2, V v3, V v4) {
        return ImmutableMap.of(v1.key(), v1, v2.key(), v2, v3.key(), v3, v4.key(), v4);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> ordered(V v1, V v2, V v3, V v4, V v5) {
        return ImmutableMap.of(v1.key(), v1, v2.key(), v2, v3.key(), v3, v4.key(), v4, v5.key(), v5);
    }

    @SafeVarargs
    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> ordered(V ... values) {
        return BindingMap.ordered(Arrays.asList(values));
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Map<K, V> ordered(Collection<V> values) {
        return values.stream().collect(BindingMap.toOrderedMap());
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Collector<V, ?, ? extends Map<K, V>> toOrderedMap() {
        return ImmutableMap.toImmutableMap(KeyAware::key, v -> v);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Builder<K, V> orderedBuilder() {
        return BindingMap.orderedBuilder(4);
    }

    public static <K extends Key<V>, V extends EntryObject<V, K>> @NonNull Builder<K, V> orderedBuilder(int expectedSize) {
        return new OrderedBuilder(expectedSize);
    }

    public static abstract class Builder<K extends Key<V>, V extends EntryObject<V, K>> {
        static final int DEFAULT_INITIAL_CAPACITY = 4;

        Builder() {
        }

        public final @NonNull Builder<K, V> add(V value) {
            this.addEntry(value.key(), value);
            return this;
        }

        @SafeVarargs
        public final @NonNull Builder<K, V> addAll(V ... values) {
            return this.addAll((Collection<V>)Arrays.asList(values));
        }

        public final @NonNull Builder<K, V> addAll(Collection<V> values) {
            this.addEntries(Collections2.transform(values, value -> Map.entry(value.key(), value)));
            return this;
        }

        public abstract @NonNull Map<K, V> build();

        abstract void addEntry(K var1, V var2);

        abstract void addEntries(Collection<Map.Entry<K, V>> var1);
    }

    private static final class UnorderedBuilder<K extends Key<V>, V extends EntryObject<V, K>>
    extends Builder<K, V> {
        private final ArrayList<Map.Entry<K, V>> buffer;

        UnorderedBuilder(int expectedSize) {
            this.buffer = new ArrayList(expectedSize);
        }

        @Override
        public Map<K, V> build() {
            return Map.ofEntries(this.buffer.toArray(new Map.Entry[0]));
        }

        @Override
        void addEntry(K key, V value) {
            this.buffer.add(Map.entry(key, value));
        }

        @Override
        void addEntries(Collection<Map.Entry<K, V>> entries) {
            this.buffer.addAll(entries);
        }
    }

    private static final class OrderedBuilder<K extends Key<V>, V extends EntryObject<V, K>>
    extends Builder<K, V> {
        private final ImmutableMap.Builder<K, V> delegate;

        OrderedBuilder(int expectedSize) {
            this.delegate = ImmutableMap.builderWithExpectedSize((int)expectedSize);
        }

        @Override
        public Map<K, V> build() {
            return this.delegate.build();
        }

        @Override
        void addEntry(K key, V value) {
            this.delegate.put(key, value);
        }

        @Override
        void addEntries(Collection<Map.Entry<K, V>> entries) {
            this.delegate.putAll(entries);
        }
    }
}

