/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime;

import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.util.PatternUtil;
import org.osgi.framework.ServiceReference;

public final class FilterInfo
extends WhiteboardServiceInfo<Filter> {
    private final String name;
    private final String[] patterns;
    private final String[] servletNames;
    private final String[] regexs;
    private final boolean asyncSupported;
    private final DispatcherType[] dispatcher;
    private final Map<String, String> initParams;

    public FilterInfo(ServiceReference<Filter> ref) {
        super(ref);
        this.name = this.getStringProperty(ref, "osgi.http.whiteboard.filter.name");
        this.asyncSupported = this.getBooleanProperty(ref, "osgi.http.whiteboard.filter.asyncSupported");
        this.servletNames = this.getStringArrayProperty(ref, "osgi.http.whiteboard.filter.servlet");
        this.patterns = this.getStringArrayProperty(ref, "osgi.http.whiteboard.filter.pattern");
        this.regexs = this.getStringArrayProperty(ref, "osgi.http.whiteboard.filter.regex");
        this.initParams = this.getInitParams(ref, "filter.init.");
        String[] dispatcherNames = this.getStringArrayProperty(ref, "osgi.http.whiteboard.filter.dispatcher");
        if (dispatcherNames != null && dispatcherNames.length > 0) {
            DispatcherType[] dispatchers = new DispatcherType[dispatcherNames.length];
            for (int i = 0; i < dispatchers.length; ++i) {
                try {
                    dispatchers[i] = DispatcherType.valueOf((String)dispatcherNames[i].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    dispatchers = null;
                    break;
                }
            }
            this.dispatcher = dispatchers;
        } else {
            this.dispatcher = new DispatcherType[]{DispatcherType.REQUEST};
        }
    }

    @Override
    public boolean isValid() {
        boolean valid;
        boolean bl = valid = super.isValid() && (!this.isEmpty(this.patterns) || !this.isEmpty(this.regexs) || !this.isEmpty(this.servletNames));
        if (valid) {
            if (this.patterns != null) {
                for (String p : this.patterns) {
                    if (PatternUtil.isValidPattern(p)) continue;
                    valid = false;
                    break;
                }
            }
            if (valid && this.regexs != null) {
                for (String p : this.regexs) {
                    try {
                        Pattern.compile(p);
                    }
                    catch (PatternSyntaxException pse) {
                        valid = false;
                        break;
                    }
                }
            }
        }
        if (valid && (this.dispatcher == null || this.dispatcher.length == 0)) {
            valid = false;
        }
        return valid;
    }

    public String getName() {
        return this.name;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public String[] getServletNames() {
        return this.servletNames;
    }

    public String[] getRegexs() {
        return this.regexs;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public DispatcherType[] getDispatcher() {
        return this.dispatcher;
    }

    public Map<String, String> getInitParameters() {
        return this.initParams;
    }
}

