/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedMetadata;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedMetadata;

@Beta
public final class ImmutableMetadataExtension
implements NormalizedNodeStreamWriter.MetadataExtension {
    private final Deque<BuilderEntry> builders = new ArrayDeque<BuilderEntry>();
    private ImmutableNormalizedMetadata result;

    public void enter(YangInstanceIdentifier.PathArgument identifier) {
        this.checkNotDone();
        this.builders.push(new BuilderEntry(identifier, ImmutableNormalizedMetadata.builder()));
    }

    public void exit() {
        this.checkNotDone();
        BuilderEntry last = this.builders.pop();
        ImmutableNormalizedMetadata metadata = last.builder.build();
        BuilderEntry current = this.builders.peek();
        if (current != null) {
            if (!metadata.getAnnotations().isEmpty() || !metadata.getChildren().isEmpty()) {
                current.builder().withChild(last.identifier, metadata);
            }
        } else {
            this.result = metadata;
        }
    }

    public Optional<NormalizedMetadata> getResult() {
        Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"Metadata tree has not been completely built");
        return this.result.getAnnotations().isEmpty() ? Optional.empty() : Optional.of(this.result);
    }

    public void metadata(ImmutableMap<QName, Object> metadata) throws IOException {
        this.builders.peek().builder.withAnnotations((Map<QName, Object>)metadata);
    }

    private void checkNotDone() {
        Preconditions.checkState((this.result != null ? 1 : 0) != 0, (Object)"Metadata already completed");
    }

    @NonNullByDefault
    private record BuilderEntry(YangInstanceIdentifier.PathArgument identifier, ImmutableNormalizedMetadata.Builder builder) {
        BuilderEntry {
            Objects.requireNonNull(identifier);
            Objects.requireNonNull(builder);
        }
    }
}

