/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.List;
import org.keycloak.adapters.authorization.TokenPrincipal;
import org.keycloak.adapters.authorization.spi.HttpRequest;
import org.keycloak.adapters.authorization.util.JsonUtils;
import org.keycloak.adapters.authorization.util.PlaceHolderResolver;
import org.keycloak.adapters.authorization.util.PlaceHolders;
import org.keycloak.util.JsonSerialization;

public class KeycloakSecurityContextPlaceHolderResolver
implements PlaceHolderResolver {
    public static final String NAME = "keycloak";

    @Override
    public List<String> resolve(String placeHolder, HttpRequest request) {
        String source = placeHolder.substring(placeHolder.indexOf(46) + 1);
        TokenPrincipal principal = request.getPrincipal();
        if (source.endsWith("access_token")) {
            return Arrays.asList(principal.getRawToken());
        }
        if (!source.startsWith("access_token[")) {
            throw new RuntimeException("Invalid placeholder [" + placeHolder + "]");
        }
        JsonNode jsonNode = JsonSerialization.mapper.valueToTree((Object)principal.getToken());
        return JsonUtils.getValues(jsonNode, PlaceHolders.getParameter(source, "Invalid placeholder [" + placeHolder + "]"));
    }
}

