/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.keycloak.protocol.oidc.client.authentication.ClientCredentialsProvider;
import org.keycloak.protocol.oidc.client.authentication.ClientCredentialsProviderUtils;
import org.keycloak.representations.adapters.config.AdapterConfig;

public class Configuration
extends AdapterConfig {
    @JsonIgnore
    private HttpClient httpClient;
    @JsonIgnore
    private ClientCredentialsProvider clientCredentialsProvider;

    public Configuration() {
    }

    public Configuration(String authServerUrl, String realm, String clientId, Map<String, Object> clientCredentials, HttpClient httpClient) {
        this.authServerUrl = authServerUrl;
        this.setAuthServerUrl(authServerUrl);
        this.setRealm(realm);
        this.setResource(clientId);
        this.setCredentials(clientCredentials);
        this.httpClient = httpClient;
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = HttpClients.createDefault();
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setClientCredentialsProvider(ClientCredentialsProvider clientCredentialsProvider) {
        this.clientCredentialsProvider = clientCredentialsProvider;
    }

    public ClientCredentialsProvider getClientCredentialsProvider() {
        if (this.clientCredentialsProvider == null) {
            this.clientCredentialsProvider = ClientCredentialsProviderUtils.bootstrapClientAuthenticator(this);
        }
        return this.clientCredentialsProvider;
    }
}

