/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.def;

import java.security.Key;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESWrapEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.keycloak.jose.jwe.JWEKeyStorage;
import org.keycloak.jose.jwe.alg.JWEAlgorithmProvider;
import org.keycloak.jose.jwe.enc.JWEEncryptionProvider;

public class AesKeyWrapAlgorithmProvider
implements JWEAlgorithmProvider {
    @Override
    public byte[] decodeCek(byte[] encodedCek, Key encryptionKey) throws Exception {
        AESWrapEngine encrypter = new AESWrapEngine();
        encrypter.init(false, (CipherParameters)new KeyParameter(encryptionKey.getEncoded()));
        return encrypter.unwrap(encodedCek, 0, encodedCek.length);
    }

    @Override
    public byte[] encodeCek(JWEEncryptionProvider encryptionProvider, JWEKeyStorage keyStorage, Key encryptionKey) throws Exception {
        AESWrapEngine encrypter = new AESWrapEngine();
        encrypter.init(true, (CipherParameters)new KeyParameter(encryptionKey.getEncoded()));
        byte[] cekBytes = keyStorage.getCekBytes();
        return encrypter.wrap(cekBytes, 0, cekBytes.length);
    }
}

