/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.util;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.FluentFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import org.opendaylight.mdsal.binding.util.CheckedConsumer;
import org.opendaylight.mdsal.binding.util.CheckedFunction;
import org.opendaylight.mdsal.binding.util.InterruptibleCheckedConsumer;
import org.opendaylight.mdsal.binding.util.InterruptibleCheckedFunction;
import org.opendaylight.mdsal.binding.util.TypedReadTransaction;
import org.opendaylight.mdsal.binding.util.TypedReadWriteTransaction;
import org.opendaylight.mdsal.binding.util.TypedWriteTransaction;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.datastores.rev180214.Datastore;

@Beta
public interface ManagedTransactionFactory {
    public <D extends Datastore, E extends Exception, R> R applyInterruptiblyWithNewReadOnlyTransactionAndClose(D var1, InterruptibleCheckedFunction<TypedReadTransaction<D>, R, E> var2) throws E, InterruptedException;

    public <D extends Datastore, E extends Exception, R> R applyWithNewReadOnlyTransactionAndClose(D var1, CheckedFunction<TypedReadTransaction<D>, R, E> var2) throws E;

    @CheckReturnValue
    public <D extends Datastore, E extends Exception, R> FluentFuture<R> applyWithNewReadWriteTransactionAndSubmit(D var1, InterruptibleCheckedFunction<TypedReadWriteTransaction<D>, R, E> var2);

    public <D extends Datastore, E extends Exception> void callInterruptiblyWithNewReadOnlyTransactionAndClose(D var1, InterruptibleCheckedConsumer<TypedReadTransaction<D>, E> var2) throws E, InterruptedException;

    public <D extends Datastore, E extends Exception> void callWithNewReadOnlyTransactionAndClose(D var1, CheckedConsumer<TypedReadTransaction<D>, E> var2) throws E;

    @CheckReturnValue
    public <D extends Datastore, E extends Exception> FluentFuture<? extends Object> callWithNewReadWriteTransactionAndSubmit(D var1, InterruptibleCheckedConsumer<TypedReadWriteTransaction<D>, E> var2);

    @CheckReturnValue
    public <D extends Datastore, E extends Exception> FluentFuture<? extends Object> callWithNewWriteOnlyTransactionAndSubmit(D var1, InterruptibleCheckedConsumer<TypedWriteTransaction<D>, E> var2);
}

