/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.ddata;

import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000514QAD\b\u0001'UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tI\u0001\u0011\t\u0011)A\u0005K!A\u0001\u0006\u0001BC\u0002\u0013\u0005\u0011\u0006\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u001d\u0011\u0004A1A\u0005\n%Baa\r\u0001!\u0002\u0013)\u0003b\u0002\u001b\u0001\u0001\u0004%I!\u000e\u0005\b\t\u0002\u0001\r\u0011\"\u0003F\u0011\u0019Y\u0005\u0001)Q\u0005m!)A\n\u0001C\u0001\u001b\")q\f\u0001C\u0001A\")!\r\u0001C\u0001G\n)\u0002+Y=m_\u0006$7+\u001b>f\u0003\u001e<'/Z4bi>\u0014(B\u0001\t\u0012\u0003\u0015!G-\u0019;b\u0015\t\u00112#A\u0004dYV\u001cH/\u001a:\u000b\u0003Q\tA!Y6lCN\u0011\u0001A\u0006\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u00071|wm\u0001\u0001\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0005\u0005\u001a\u0012!B3wK:$\u0018BA\u0012!\u00059aunZ4j]\u001e\fE-\u00199uKJ\f\u0001\u0003\\8h'&TX-\u0012=dK\u0016$\u0017N\\4\u0011\u0005]1\u0013BA\u0014\u0019\u0005\rIe\u000e^\u0001\r[\u0006DhI]1nKNK'0Z\u000b\u0002K\u0005iQ.\u0019=Ge\u0006lWmU5{K\u0002\na\u0001P5oSRtD\u0003B\u00170aE\u0002\"A\f\u0001\u000e\u0003=AQ\u0001H\u0003A\u0002yAQ\u0001J\u0003A\u0002\u0015BQ\u0001K\u0003A\u0002\u0015\n\u0011c^1s]NK'0Z#yG\u0016,G-\u001b8h\u0003I9\u0018M\u001d8TSj,W\t_2fK\u0012Lgn\u001a\u0011\u0002\u001f5\f\u0007\u0010U1zY>\fGMQ=uKN,\u0012A\u000e\t\u0005oy\nUE\u0004\u00029yA\u0011\u0011\bG\u0007\u0002u)\u00111(H\u0001\u0007yI|w\u000e\u001e \n\u0005uB\u0012A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n\u0019Q*\u00199\u000b\u0005uB\u0002CA\u001cC\u0013\t\u0019\u0005I\u0001\u0004TiJLgnZ\u0001\u0014[\u0006D\b+Y=m_\u0006$')\u001f;fg~#S-\u001d\u000b\u0003\r&\u0003\"aF$\n\u0005!C\"\u0001B+oSRDqAS\u0005\u0002\u0002\u0003\u0007a'A\u0002yIE\n\u0001#\\1y!\u0006LHn\\1e\u0005f$Xm\u001d\u0011\u0002#U\u0004H-\u0019;f!\u0006LHn\\1e'&TX\rF\u0002G\u001dvCQaT\u0006A\u0002A\u000b1a[3z!\t\t&L\u0004\u0002S1:\u00111k\u0016\b\u0003)Zs!!O+\n\u0003QI!AE\n\n\u0005A\t\u0012BA-\u0010\u0003\rYU-_\u0005\u00037r\u0013QaS3z\u0013\u0012T!!W\b\t\u000by[\u0001\u0019A\u0013\u0002\tML'0Z\u0001\u000bO\u0016$X*\u0019=TSj,GCA\u0013b\u0011\u0015yE\u00021\u0001Q\u0003\u0019\u0011X-\\8wKR\u0011a\t\u001a\u0005\u0006\u001f6\u0001\r\u0001\u0015\u0015\u0003\u0001\u0019\u0004\"a\u001a6\u000e\u0003!T!![\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002lQ\nY\u0011J\u001c;fe:\fG.\u00119j\u0001")
@InternalApi
public class PayloadSizeAggregator {
    private final LoggingAdapter log;
    private final int logSizeExceeding;
    private final int maxFrameSize;
    private final int warnSizeExceeding;
    private Map<String, Object> maxPayloadBytes;

    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    private int warnSizeExceeding() {
        return this.warnSizeExceeding;
    }

    private Map<String, Object> maxPayloadBytes() {
        return this.maxPayloadBytes;
    }

    private void maxPayloadBytes_$eq(Map<String, Object> x$1) {
        this.maxPayloadBytes = x$1;
    }

    public void updatePayloadSize(String key, int size) {
        if (size > 0) {
            Option option = this.maxPayloadBytes().get((Object)key);
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                int max = BoxesRunTime.unboxToInt((Object)some.value());
                if (size > max) {
                    this.maxPayloadBytes_$eq((Map<String, Object>)((Map)this.maxPayloadBytes().updated((Object)key, (Object)BoxesRunTime.boxToInteger((int)PayloadSizeAggregator.newMax$1(size)))));
                    if (size >= this.logSizeExceeding) {
                        this.logSize$1(size, key);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                this.maxPayloadBytes_$eq((Map<String, Object>)((Map)this.maxPayloadBytes().updated((Object)key, (Object)BoxesRunTime.boxToInteger((int)PayloadSizeAggregator.newMax$1(size)))));
                if (size >= this.logSizeExceeding) {
                    this.logSize$1(size, key);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                throw new MatchError((Object)option);
            }
        }
    }

    public int getMaxSize(String key) {
        return BoxesRunTime.unboxToInt((Object)this.maxPayloadBytes().getOrElse((Object)key, (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public void remove(String key) {
        this.maxPayloadBytes_$eq((Map<String, Object>)((Map)this.maxPayloadBytes().$minus((Object)key)));
    }

    private static final int newMax$1(int size$1) {
        return (int)((double)size$1 * 1.1);
    }

    private final void logSize$1(int size$1, String key$1) {
        if (size$1 >= this.warnSizeExceeding()) {
            this.log.warning("Distributed data size for [{}] is [{}] bytes. Close to max remote message payload size.", (Object)key$1, (Object)BoxesRunTime.boxToInteger((int)size$1));
        } else {
            this.log.info("Distributed data size for [{}] is [{}] bytes.", key$1, BoxesRunTime.boxToInteger((int)size$1));
        }
    }

    public PayloadSizeAggregator(LoggingAdapter log, int logSizeExceeding, int maxFrameSize) {
        this.log = log;
        this.logSizeExceeding = logSizeExceeding;
        this.maxFrameSize = maxFrameSize;
        this.warnSizeExceeding = maxFrameSize * 3 / 4;
        this.maxPayloadBytes = Predef$.MODULE$.Map().empty();
    }
}

