/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.ScalarTypeObject;
import org.opendaylight.yangtools.binding.data.codec.impl.SchemaUnawareCodec;

final class EncapsulatedValueCodec
extends SchemaUnawareCodec {
    private static final MethodType OBJ_METHOD = MethodType.methodType(Object.class, Object.class);
    private static final LoadingCache<Class<? extends ScalarTypeObject>, @NonNull EncapsulatedValueCodec> CACHE = CacheBuilder.newBuilder().weakKeys().softValues().build((CacheLoader)new CacheLoader<Class<? extends ScalarTypeObject>, EncapsulatedValueCodec>(){

        public EncapsulatedValueCodec load(Class<? extends ScalarTypeObject> key) throws ReflectiveOperationException {
            Method method = key.getMethod("getValue", new Class[0]);
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            Class<?> retType = method.getReturnType();
            return new EncapsulatedValueCodec(lookup.findConstructor(key, MethodType.methodType(Void.TYPE, retType)).asType(OBJ_METHOD), lookup.unreflect(method).asType(OBJ_METHOD), retType);
        }
    });
    private final MethodHandle constructor;
    private final MethodHandle getter;
    private final Class<?> valueType;

    private EncapsulatedValueCodec(MethodHandle constructor, MethodHandle getter, Class<?> valueType) {
        this.constructor = Objects.requireNonNull(constructor);
        this.getter = Objects.requireNonNull(getter);
        this.valueType = Objects.requireNonNull(valueType);
    }

    static @NonNull EncapsulatedValueCodec of(Class<?> typeClz) throws ExecutionException {
        return (EncapsulatedValueCodec)CACHE.get(typeClz.asSubclass(ScalarTypeObject.class));
    }

    static @NonNull EncapsulatedValueCodec ofUnchecked(Class<?> typeClz) {
        return (EncapsulatedValueCodec)CACHE.getUnchecked(typeClz.asSubclass(ScalarTypeObject.class));
    }

    boolean canAcceptObject(Object value) {
        return this.valueType.isInstance(value);
    }

    @Override
    protected Object deserializeImpl(Object input) {
        try {
            return this.constructor.invokeExact(input);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected Object serializeImpl(Object input) {
        try {
            return Verify.verifyNotNull((Object)this.getter.invokeExact(input));
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }
}

